/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandFramework;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.Message;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.utils.Utils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandArguments {
    private Set<String> parsedFlags;
    private Map<String, List<String>> parsedOptions;
    private final Command command;
    private final CommandSender commandSender;
    private final org.bukkit.command.Command bukkitCommand;
    private final String label;
    private final String[] arguments;

    CommandArguments(CommandSender commandSender, org.bukkit.command.Command bukkitCommand, Command command, String label, String ... arguments) {
        this.commandSender = commandSender;
        this.bukkitCommand = bukkitCommand;
        this.command = command;
        this.label = label;
        this.arguments = arguments;
    }

    @NotNull
    public <T extends CommandSender> T getSender() {
        return (T)this.commandSender;
    }

    @Nullable
    public Command getCommand() {
        return this.command;
    }

    @NotNull
    public org.bukkit.command.Command getBukkitCommand() {
        return this.bukkitCommand;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    @NotNull
    public String[] getArguments() {
        return this.arguments;
    }

    @Nullable
    public String getArgument(int index) {
        return this.arguments.length > index && index >= 0 ? this.arguments[index] : null;
    }

    @NotNull
    public String getArgument(int index, String defaultValue) {
        return this.arguments.length > index && index >= 0 ? this.arguments[index] : defaultValue;
    }

    public int getArgumentAsInt(int index) {
        return Utils.getInt(this.getArgument(index));
    }

    public double getArgumentAsDouble(int index) {
        return Utils.getDouble(this.getArgument(index));
    }

    public float getArgumentAsFloat(int index) {
        return Utils.getFloat(this.getArgument(index));
    }

    public long getArgumentAsLong(int index) {
        return Utils.getLong(this.getArgument(index));
    }

    public boolean getArgumentAsBoolean(int index) {
        return "true".equalsIgnoreCase(this.getArgument(index));
    }

    public boolean isArgumentsEmpty() {
        return this.arguments.length == 0;
    }

    public void sendMessage(String message) {
        if (message == null) {
            return;
        }
        this.commandSender.sendMessage(Message.applyColorFormatter(message));
    }

    public void sendMessage(String message, Object ... params) {
        if (message == null) {
            return;
        }
        this.commandSender.sendMessage(Message.applyColorFormatter(MessageFormat.format(message, params)));
    }

    public boolean sendMessage(Message message) {
        return message.sendMessage(this.command, this);
    }

    public void sendMessage(Component component) {
        this.commandSender.sendMessage(component);
    }

    public boolean isSenderConsole() {
        return !this.isSenderPlayer();
    }

    public boolean isSenderPlayer() {
        return this.commandSender instanceof Player;
    }

    public boolean hasPermission(String permission) {
        return permission.isEmpty() || this.commandSender.hasPermission(permission);
    }

    public int getLength() {
        return this.arguments.length;
    }

    public Optional<Player> getPlayer(String name) {
        return Optional.ofNullable(Bukkit.getPlayer((String)name));
    }

    public Optional<Player> getPlayer(int index) {
        return this.getPlayer(this.getArgument(index));
    }

    public String concatArguments() {
        return String.join((CharSequence)" ", this.arguments);
    }

    public String concatRangeOf(int from, int to) {
        return String.join((CharSequence)" ", Arrays.copyOfRange(this.arguments, from, to));
    }

    public boolean isNumeric(int index) {
        return this.isNumeric(this.getArgument(index));
    }

    public boolean isNumeric(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return string.chars().allMatch(Character::isDigit);
    }

    public boolean isInteger(int index) {
        return this.isInteger(this.getArgument(index));
    }

    public boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isFloatingDecimal(int index) {
        return this.isFloatingDecimal(this.getArgument(index));
    }

    public boolean isFloatingDecimal(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean checkCooldown() {
        return CommandFramework.getInstance().getCooldownManager().hasCooldown(this);
    }

    void setParsedOptions(Map<String, List<String>> parsedOptions) {
        this.parsedOptions = parsedOptions;
    }

    @Nullable
    public List<String> getOption(@NotNull String option) {
        return this.parsedOptions.get(option);
    }

    public Optional<List<String>> findOption(@NotNull String option) {
        return Optional.ofNullable(this.getOption(option));
    }

    void setParsedFlags(Set<String> parsedFlags) {
        this.parsedFlags = parsedFlags;
    }

    public boolean isFlagPresent(@NotNull String flag) {
        return this.parsedFlags.contains(flag);
    }
}

