/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandArguments;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandHandler;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandRegistry;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.confirmations.ConfirmationManager;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.cooldown.CooldownManager;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.debug.DebugLogger;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.options.FrameworkOption;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.options.OptionManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public class CommandFramework
extends CommandHandler {
    protected static CommandFramework instance;
    private Logger logger;
    private CooldownManager cooldownManager;
    private ConfirmationManager confirmationManager;
    protected final Plugin plugin;
    private final OptionManager optionManager;
    private final CommandRegistry registry;

    public CommandFramework(@NotNull Plugin plugin) {
        this.checkRelocation();
        this.checkIsAlreadyInitialized();
        this.plugin = plugin;
        this.registry = new CommandRegistry();
        this.optionManager = new OptionManager();
        this.initializeLogger();
        super.setRegistry(this);
    }

    private void checkRelocation() {
        if (Boolean.getBoolean("commandframework.suppressrelocation")) {
            return;
        }
        String defaultPackage = new String(new byte[]{109, 101, 46, 100, 101, 115, 112, 105, 99, 97, 108, 46, 99, 111, 109, 109, 97, 110, 100, 102, 114, 97, 109, 101, 119, 111, 114, 107});
        String examplePackage = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
        String packageName = "com.github.sarhatabaot.chunkspawnerlimiter.libs";
        if (packageName.startsWith(defaultPackage) || packageName.startsWith(examplePackage)) {
            throw new IllegalStateException("Command Framework has not been relocated correctly!");
        }
    }

    private void checkIsAlreadyInitialized() {
        if (!Boolean.getBoolean("commandframework.suppress_initialization") && instance != null) {
            throw new IllegalStateException("Instance already initialized!");
        }
        instance = this;
    }

    private void initializeLogger() {
        if (this.optionManager.isEnabled(FrameworkOption.DEBUG)) {
            this.logger = new DebugLogger();
            return;
        }
        this.logger = this.plugin.getLogger();
    }

    public final void registerCommands(@NotNull Object instance) {
        this.registry.registerCommands(instance);
    }

    public final void unregisterCommand(@NotNull String commandName) {
        this.registry.unregisterCommand(commandName);
    }

    public final void unregisterCommands() {
        this.registry.unregisterCommands();
    }

    public final <A, B extends A> void addCustomParameter(@NotNull String value, @NotNull Function<CommandArguments, B> function) {
        this.parameterHandler.addCustomParameter(value, function);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull Logger logger) {
        this.logger = logger;
    }

    public final OptionManager options() {
        return this.optionManager;
    }

    @ApiStatus.Internal
    CooldownManager getCooldownManager() {
        if (this.cooldownManager == null) {
            this.cooldownManager = new CooldownManager(this);
        }
        return this.cooldownManager;
    }

    @ApiStatus.Internal
    CommandRegistry getRegistry() {
        return this.registry;
    }

    @ApiStatus.Internal
    boolean checkConfirmation(CommandSender sender, Command command, Method method) {
        if (!this.optionManager.isEnabled(FrameworkOption.CONFIRMATIONS)) {
            return false;
        }
        if (this.confirmationManager == null) {
            this.confirmationManager = new ConfirmationManager();
        }
        return this.confirmationManager.checkConfirmations(sender, command, method);
    }

    protected final void setCommandMap(CommandMap commandMap) {
        this.registry.setCommandMap(commandMap);
    }

    @NotNull
    public final List<Command> getCommands() {
        return new ArrayList<Command>(this.registry.getCommands());
    }

    @NotNull
    public final List<Command> getSubCommands() {
        return new ArrayList<Command>(this.registry.getSubCommands());
    }

    @NotNull
    public final List<Command> getAllCommands() {
        ArrayList<Command> commands = new ArrayList<Command>(this.registry.getCommands());
        commands.addAll(this.registry.getSubCommands());
        return commands;
    }

    public static CommandFramework getInstance() {
        return instance;
    }
}

