/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandArguments;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandFramework;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandRegistry;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.Message;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.ParameterHandler;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Completer;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Flag;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Option;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.exceptions.CooldownException;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.options.FrameworkOption;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.parser.OptionParser;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.utils.Utils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@ApiStatus.NonExtendable
abstract class CommandHandler
implements CommandExecutor,
TabCompleter {
    private CommandRegistry registry;
    protected ParameterHandler parameterHandler;

    CommandHandler() {
    }

    void setRegistry(CommandFramework commandFramework) {
        this.registry = commandFramework.getRegistry();
        this.parameterHandler = new ParameterHandler();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String label, String[] args) {
        boolean parseOptions;
        Map.Entry<Command, Map.Entry<Method, Object>> entry = this.registry.getCommandMatcher().getAssociatedCommand(cmd.getName(), args);
        if (entry == null) {
            return false;
        }
        Method method = entry.getValue().getKey();
        if (method == null) {
            return false;
        }
        Command command = entry.getKey();
        String permission = command.permission();
        String[] split = command.name().split("\\.");
        String[] newArgs = Arrays.copyOfRange(args, split.length - 1, args.length);
        CommandArguments arguments = new CommandArguments(sender, cmd, command, label, newArgs);
        if (command.onlyOp() && !sender.isOp()) {
            arguments.sendMessage(Message.MUST_HAVE_OP);
            return true;
        }
        if (!permission.isEmpty() && !sender.hasPermission(permission)) {
            arguments.sendMessage(Message.NO_PERMISSION);
            return true;
        }
        if (command.senderType() == Command.SenderType.PLAYER && !(sender instanceof Player)) {
            arguments.sendMessage(Message.ONLY_BY_PLAYERS);
            return true;
        }
        if (command.senderType() == Command.SenderType.CONSOLE && sender instanceof Player) {
            arguments.sendMessage(Message.ONLY_BY_CONSOLE);
            return true;
        }
        if (newArgs.length < command.min()) {
            return arguments.sendMessage(Message.SHORT_ARG_SIZE);
        }
        if (command.max() != -1 && newArgs.length > command.max()) {
            return arguments.sendMessage(Message.LONG_ARG_SIZE);
        }
        CommandFramework commandFramework = CommandFramework.getInstance();
        if (commandFramework.checkConfirmation(sender, command, method)) {
            return true;
        }
        if (!commandFramework.options().isEnabled(FrameworkOption.CUSTOM_COOLDOWN_CHECKER) && commandFramework.getCooldownManager().hasCooldown(arguments, command, method)) {
            return true;
        }
        boolean bl = parseOptions = ((Option[])method.getAnnotationsByType(Option.class)).length + ((Flag[])method.getAnnotationsByType(Flag.class)).length > 0;
        if (parseOptions) {
            OptionParser optionParser = new OptionParser(newArgs, method);
            arguments.setParsedOptions(optionParser.parseOptions());
            arguments.setParsedFlags(optionParser.parseFlags());
        }
        Runnable invocation = () -> {
            try {
                Object instance = ((Map.Entry)entry.getValue()).getValue();
                method.invoke(instance, this.parameterHandler.getParameterArray(method, arguments));
            }
            catch (Exception exception) {
                if (exception.getCause() instanceof CooldownException) {
                    return;
                }
                Utils.handleExceptions(exception);
            }
        };
        if (command.async()) {
            Plugin plugin = commandFramework.plugin;
            plugin.getServer().getScheduler().runTaskAsynchronously(plugin, invocation);
        } else {
            invocation.run();
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String label, String[] args) {
        Map.Entry<Completer, Map.Entry<Method, Object>> entry = this.registry.getCommandMatcher().getAssociatedCompleter(cmd.getName(), args);
        if (entry == null) {
            return null;
        }
        String permission = entry.getKey().permission();
        if (!permission.isEmpty() && !sender.hasPermission(permission)) {
            return null;
        }
        try {
            Method method = entry.getValue().getKey();
            Object instance = entry.getValue().getValue();
            String[] splitName = entry.getKey().name().split("\\.");
            String[] newArgs = Arrays.copyOfRange(args, splitName.length - 1, args.length);
            Object completer = method.invoke(instance, this.parameterHandler.getParameterArray(method, new CommandArguments(sender, cmd, null, label, newArgs)));
            return (List)completer;
        }
        catch (Exception exception) {
            Utils.handleExceptions(exception);
            return null;
        }
    }
}

