/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandFramework;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Completer;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.debug.Debug;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.options.FrameworkOption;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.utils.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.SimplePluginManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CommandRegistry {
    @Nullable
    private CommandMap commandMap;
    @NotNull
    private final CommandMatcher commandMatcher = new CommandMatcher();
    @NotNull
    private final Map<Command, Map.Entry<Method, Object>> commands = new HashMap<Command, Map.Entry<Method, Object>>();
    @NotNull
    private final Map<Command, Map.Entry<Method, Object>> subCommands;
    @NotNull
    private final Map<Completer, Map.Entry<Method, Object>> commandCompletions = new HashMap<Completer, Map.Entry<Method, Object>>();
    @NotNull
    private final Map<Completer, Map.Entry<Method, Object>> subCommandCompletions;

    CommandRegistry() {
        this.subCommands = new TreeMap<Command, Map.Entry<Method, Object>>(Comparator.comparing(Command::name).reversed());
        this.subCommandCompletions = new TreeMap<Completer, Map.Entry<Method, Object>>(Comparator.comparing(Completer::name).reversed());
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        if (pluginManager instanceof SimplePluginManager) {
            SimplePluginManager manager = (SimplePluginManager)pluginManager;
            try {
                Field field = SimplePluginManager.class.getDeclaredField("commandMap");
                field.setAccessible(true);
                this.commandMap = (CommandMap)field.get(manager);
            }
            catch (ReflectiveOperationException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setCommandMap(@NotNull CommandMap commandMap) {
        this.commandMap = commandMap;
    }

    protected void registerCommands(@NotNull Object instance) {
        CommandFramework commandFramework = CommandFramework.getInstance();
        boolean notDebug = !commandFramework.options().isEnabled(FrameworkOption.DEBUG);
        for (Method method : instance.getClass().getMethods()) {
            if (notDebug && method.isAnnotationPresent(Debug.class)) continue;
            Command command = method.getAnnotation(Command.class);
            if (command != null) {
                this.registerCommand(command, method, instance);
                Stream.of(command.aliases()).forEach(alias -> this.registerCommand(Utils.createCommand(command, alias), method, instance));
                continue;
            }
            if (!method.isAnnotationPresent(Completer.class)) continue;
            if (!List.class.isAssignableFrom(method.getReturnType())) {
                commandFramework.getLogger().log(Level.WARNING, "Skipped registration of ''{0}'' because it is not returning java.util.List type.", method.getName());
                continue;
            }
            Completer completer = method.getAnnotation(Completer.class);
            if (completer.name().contains(".")) {
                this.subCommandCompletions.put(completer, Utils.mapEntry(method, instance));
                continue;
            }
            this.commandCompletions.put(completer, Utils.mapEntry(method, instance));
        }
        this.subCommands.forEach((key, value) -> {
            String splitName = key.name().split("\\.")[0];
            if (this.commands.keySet().stream().noneMatch(cmd -> cmd.name().equals(splitName))) {
                commandFramework.getLogger().log(Level.WARNING, "A sub-command (name: ''{0}'') is directly registered without a main command.", key.name());
                this.registerCommand(Utils.createCommand(key, splitName), null, null);
            }
        });
    }

    protected void registerCommand(Command command, Method method, Object instance) {
        CommandFramework commandFramework = CommandFramework.getInstance();
        String cmdName = command.name();
        if (cmdName.contains(".")) {
            this.subCommands.put(command, Utils.mapEntry(method, instance));
        } else {
            this.commands.put(command, Utils.mapEntry(method, instance));
            try {
                Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                constructor.setAccessible(true);
                PluginCommand pluginCommand = (PluginCommand)constructor.newInstance(cmdName, commandFramework.plugin);
                pluginCommand.setExecutor((CommandExecutor)commandFramework);
                pluginCommand.setUsage(command.usage());
                pluginCommand.setPermission(command.permission().isEmpty() ? null : command.permission());
                pluginCommand.setDescription(command.desc());
                String fallbackPrefix = command.fallbackPrefix().isEmpty() ? commandFramework.plugin.getName() : command.fallbackPrefix();
                this.commandMap.register(fallbackPrefix, (org.bukkit.command.Command)pluginCommand);
            }
            catch (Exception exception) {
                Utils.handleExceptions(exception);
            }
        }
    }

    protected void unregisterCommand(@NotNull String commandName) {
        if (commandName.contains(".")) {
            commandName = commandName.split("\\.")[0];
        }
        Map.Entry<Command, Map.Entry<Method, Object>> entry = this.commandMatcher.getAssociatedCommand(commandName, new String[0]);
        CommandFramework commandFramework = CommandFramework.getInstance();
        if (entry == null) {
            commandFramework.plugin.getLogger().log(Level.WARNING, "Command removal is failed because there is no command named ''{0}''!", commandName);
            return;
        }
        Command command = entry.getKey();
        String name = command.name();
        PluginCommand pluginCommand = commandFramework.plugin.getServer().getPluginCommand(name);
        Optional.ofNullable(pluginCommand).ifPresent(cmd -> {
            if (!pluginCommand.getPlugin().equals((Object)commandFramework.plugin)) {
                return;
            }
            try {
                cmd.unregister(this.commandMap);
                Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
                field.setAccessible(true);
                Map knownCommands = (Map)field.get(this.commandMap);
                knownCommands.remove(name);
            }
            catch (Exception exception) {
                commandFramework.getLogger().log(Level.WARNING, "Something went wrong while trying to unregister command(name: {0}) from server!", name);
            }
            this.commands.remove(command);
            this.subCommands.entrySet().removeIf(subEntry -> ((Command)subEntry.getKey()).name().startsWith(name));
        });
    }

    protected void unregisterCommands() {
        Iterator names = this.commands.keySet().stream().map(Command::name).iterator();
        while (names.hasNext()) {
            this.unregisterCommand((String)names.next());
        }
    }

    @NotNull
    protected Set<Command> getCommands() {
        return this.commands.keySet();
    }

    @NotNull
    protected Set<Command> getSubCommands() {
        return this.subCommands.keySet();
    }

    @NotNull
    protected CommandMatcher getCommandMatcher() {
        return this.commandMatcher;
    }

    protected final class CommandMatcher {
        protected CommandMatcher() {
        }

        @Nullable
        public Map.Entry<Command, Map.Entry<Method, Object>> getAssociatedCommand(@NotNull String commandName, @NotNull String[] possibleArgs) {
            String name;
            Command command = null;
            for (Command cmd : CommandRegistry.this.subCommands.keySet()) {
                String cmdName;
                name = cmd.name();
                if (name.equals(cmdName = commandName + (String)(possibleArgs.length == 0 ? "" : "." + String.join((CharSequence)".", Arrays.copyOfRange(possibleArgs, 0, name.split("\\.").length - 1))))) {
                    command = cmd;
                    break;
                }
                if (!name.equalsIgnoreCase(cmdName)) continue;
                command = cmd;
                break;
            }
            if (command != null) {
                return Utils.mapEntry(command, CommandRegistry.this.subCommands.get(command));
            }
            for (Command cmd : CommandRegistry.this.commands.keySet()) {
                name = cmd.name();
                if (!name.equalsIgnoreCase(commandName)) {
                    if (!Stream.of(cmd.aliases()).anyMatch(commandName::equalsIgnoreCase)) continue;
                }
                return Utils.mapEntry(cmd, CommandRegistry.this.commands.get(cmd));
            }
            return null;
        }

        @Nullable
        public Map.Entry<Completer, Map.Entry<Method, Object>> getAssociatedCompleter(@NotNull String commandName, @NotNull String[] possibleArgs) {
            String name;
            for (Completer comp : CommandRegistry.this.subCommandCompletions.keySet()) {
                String cmdName;
                name = comp.name();
                if (!name.equalsIgnoreCase(cmdName = commandName + (String)(possibleArgs.length == 0 ? "" : "." + String.join((CharSequence)".", Arrays.copyOfRange(possibleArgs, 0, name.split("\\.").length - 1)))) && !Stream.of(comp.aliases()).anyMatch(target -> target.equalsIgnoreCase(cmdName) || target.equalsIgnoreCase(commandName))) continue;
                return Utils.mapEntry(comp, CommandRegistry.this.subCommandCompletions.get(comp));
            }
            for (Completer comp : CommandRegistry.this.commandCompletions.keySet()) {
                name = comp.name();
                if (!name.equalsIgnoreCase(commandName)) {
                    if (!Stream.of(comp.aliases()).anyMatch(commandName::equalsIgnoreCase)) continue;
                }
                return Utils.mapEntry(comp, CommandRegistry.this.commandCompletions.get(comp));
            }
            return null;
        }
    }
}

