/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandArguments;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum Message {
    SHORT_ARG_SIZE("&cRequired argument length is less than needed!", true),
    LONG_ARG_SIZE("&cRequired argument length greater than needed!", true),
    ONLY_BY_PLAYERS("&cThis command is only executable by players!"),
    ONLY_BY_CONSOLE("&cThis command is only executable by console!"),
    NO_PERMISSION("&cYou don't have enough permission to execute this command!"),
    MUST_HAVE_OP("&cYou must have OP to execute this command!"),
    WAIT_BEFORE_USING_AGAIN("&cYou have to wait before using this command again!");

    private BiFunction<Command, CommandArguments, Boolean> message = (command, arguments) -> {
        if (sendUsage && !MessageHelper.SEND_USAGE.apply((Command)command, (CommandArguments)arguments).booleanValue()) {
            return true;
        }
        arguments.sendMessage(message);
        return true;
    };
    @NotNull
    private static Function<String, String> colorFormatter;

    private Message(String message) {
        this(message, false);
    }

    private Message(String message, boolean sendUsage) {
    }

    public static void setColorFormatter(@NotNull Function<String, String> colorFormatter) {
        Message.colorFormatter = colorFormatter;
    }

    public void setMessage(BiFunction<Command, CommandArguments, Boolean> message) {
        this.message = message;
    }

    @ApiStatus.Internal
    static String applyColorFormatter(@NotNull String string) {
        return colorFormatter.apply(string);
    }

    @ApiStatus.Internal
    boolean sendMessage(Command command, CommandArguments arguments) {
        return this.message.apply(command, arguments);
    }

    static {
        colorFormatter = string -> ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    private static class MessageHelper {
        private static final BiFunction<Command, CommandArguments, Boolean> SEND_USAGE = (command, arguments) -> {
            String usage = command.usage();
            if (!usage.isEmpty()) {
                arguments.sendMessage(usage);
                return false;
            }
            return true;
        };

        private MessageHelper() {
        }
    }
}

