/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandArguments;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Default;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Param;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.exceptions.CommandException;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ParameterHandler {
    @NotNull
    private final Map<String, Function<CommandArguments, ?>> customParametersMap = new HashMap();

    public <A, B extends A> void addCustomParameter(@NotNull String value, @NotNull Function<CommandArguments, B> function) {
        if (this.customParametersMap.containsKey(value)) {
            throw new CommandException("Custom parameter function called ''{0}'' is already registered!", value);
        }
        this.customParametersMap.put(value, function);
    }

    @NotNull
    public Object[] getParameterArray(Method method, CommandArguments commandArguments) throws Exception {
        Parameter[] parameters = method.getParameters();
        Object[] methodParameters = new Object[parameters.length];
        block2: for (int i = 0; i < parameters.length; ++i) {
            String simpleName = parameters[i].getType().getSimpleName();
            if ("CommandArguments".equals(simpleName)) {
                methodParameters[i] = commandArguments;
                continue;
            }
            for (Annotation annotation : parameters[i].getAnnotations()) {
                if (!(annotation instanceof Param)) continue;
                String value = ((Param)annotation).value();
                if (!this.customParametersMap.containsKey(value)) {
                    throw new CommandException("Custom parameter (type: {0}, value: {1}) is requested but return function is not found!", simpleName, value);
                }
                methodParameters[i] = this.customParametersMap.get(value).apply(commandArguments);
                if (methodParameters[i] != null || !parameters[i].isAnnotationPresent(Default.class)) continue block2;
                String defaultValue = parameters[i].getAnnotation(Default.class).value();
                if (!parameters[i].getType().isInstance(String.class)) {
                    Class<?> clazz = parameters[i].getType();
                    if (!Primitives.isWrapperType(clazz)) {
                        try {
                            methodParameters[i] = clazz.getMethod("valueOf", String.class).invoke(null, defaultValue);
                            continue block2;
                        }
                        catch (Exception exception) {
                            throw new CommandException("Static method {0}#valueOf(String) does not exist!", clazz.getSimpleName());
                        }
                    }
                    methodParameters[i] = Primitives.wrap(clazz).getMethod("valueOf", String.class).invoke(null, defaultValue);
                    continue block2;
                }
                methodParameters[i] = defaultValue;
                continue block2;
            }
            if (!this.customParametersMap.containsKey(simpleName)) {
                throw new CommandException("Custom parameter (type: {0}) is requested but return function is not found!", simpleName);
            }
            methodParameters[i] = this.customParametersMap.get(simpleName).apply(commandArguments);
        }
        return methodParameters;
    }
}

