/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs.confirmations;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Confirmation;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.utils.SelfExpiringHashMap;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.utils.SelfExpiringMap;
import java.lang.reflect.Method;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ConfirmationManager {
    private final SelfExpiringMap<CommandSender, Command> confirmations = new SelfExpiringHashMap<CommandSender, Command>();

    public boolean checkConfirmations(CommandSender sender, Command command, Method method) {
        if (method == null) {
            return false;
        }
        if (!method.isAnnotationPresent(Confirmation.class)) {
            return false;
        }
        Confirmation confirmation = method.getAnnotation(Confirmation.class);
        if (confirmation.expireAfter() <= 0) {
            return false;
        }
        boolean isConsoleSender = sender instanceof ConsoleCommandSender;
        if (isConsoleSender && !confirmation.overrideConsole()) {
            return false;
        }
        if (!isConsoleSender && !confirmation.bypassPerm().isEmpty() && sender.hasPermission(confirmation.bypassPerm())) {
            return false;
        }
        if (this.confirmations.containsKey(sender)) {
            this.confirmations.remove(sender);
            return false;
        }
        this.confirmations.put(sender, command, confirmation.timeUnit().toMillis(confirmation.expireAfter()));
        sender.sendMessage(confirmation.message());
        return true;
    }
}

