/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs.cooldown;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandArguments;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandFramework;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.Message;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Completer;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Cooldown;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.exceptions.CommandException;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.exceptions.CooldownException;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.options.FrameworkOption;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.utils.Utils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class CooldownManager {
    private final CommandFramework commandFramework;
    private final Map<CommandSender, Map<Command, Long>> cooldowns;

    public CooldownManager(CommandFramework commandFramework) {
        this.commandFramework = commandFramework;
        this.cooldowns = new HashMap<CommandSender, Map<Command, Long>>();
    }

    public boolean hasCooldown(CommandArguments arguments) {
        if (!this.commandFramework.options().isEnabled(FrameworkOption.CUSTOM_COOLDOWN_CHECKER)) {
            throw new CommandException("Custom cooldown checker option must be enabled to use CommandArguments#hasCooldown method!");
        }
        Method method = this.getCallingMethod();
        if (method == null) {
            return false;
        }
        if (method.isAnnotationPresent(Completer.class)) {
            throw new CommandException("You can not use CommandArguments#hasCooldown method in a tab completer!");
        }
        Command command = method.getAnnotation(Command.class);
        return this.hasCooldown(arguments, command, method);
    }

    public boolean hasCooldown(CommandArguments arguments, Command command, Method method) {
        if (method == null) {
            return false;
        }
        if (!method.isAnnotationPresent(Cooldown.class)) {
            return false;
        }
        Cooldown cooldown = method.getAnnotation(Cooldown.class);
        if (cooldown.value() <= 0L) {
            return false;
        }
        boolean isConsoleSender = arguments.isSenderConsole();
        Object sender = arguments.getSender();
        if (isConsoleSender && !cooldown.overrideConsole()) {
            return false;
        }
        if (!isConsoleSender && !cooldown.bypassPerm().isEmpty() && sender.hasPermission(cooldown.bypassPerm())) {
            return false;
        }
        Map<Command, Long> cooldownMap = this.cooldowns.get(sender);
        if (cooldownMap == null) {
            this.cooldowns.put((CommandSender)sender, Utils.mapOf(command, System.currentTimeMillis()));
            return false;
        }
        if (!cooldownMap.containsKey(command)) {
            cooldownMap.put(command, System.currentTimeMillis());
            this.cooldowns.replace((CommandSender)sender, cooldownMap);
            return false;
        }
        long remainingSeconds = (System.currentTimeMillis() - cooldownMap.get(command)) / 1000L % 60L;
        long cooldownInSeconds = cooldown.timeUnit().toSeconds(cooldown.value());
        int timeBetween = (int)(cooldownInSeconds - remainingSeconds);
        if (timeBetween > 0) {
            arguments.sendMessage(Message.WAIT_BEFORE_USING_AGAIN);
            return this.handleCooldowns();
        }
        cooldownMap.put(command, System.currentTimeMillis());
        this.cooldowns.replace((CommandSender)sender, cooldownMap);
        return false;
    }

    private boolean handleCooldowns() {
        if (!this.commandFramework.options().isEnabled(FrameworkOption.CUSTOM_COOLDOWN_CHECKER)) {
            return true;
        }
        throw new CooldownException();
    }

    private Method getCallingMethod() {
        try {
            Method[] methods;
            StackTraceElement callingElement = Thread.currentThread().getStackTrace()[4];
            String methodName = callingElement.getMethodName();
            Class<?> callingClass = Class.forName(callingElement.getClassName());
            for (Method method : methods = callingClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
        }
        catch (Exception exception) {
            Utils.handleExceptions(exception);
        }
        return null;
    }
}

