/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs.parser;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Flag;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Option;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class OptionParser {
    private final Flag[] flags;
    private final Option[] options;
    private final Set<String> arguments;
    private final Set<String> parsedFlags;
    private final Map<String, List<String>> parsedOptions;

    public OptionParser(String[] arguments, Method method) {
        this.flags = (Flag[])method.getAnnotationsByType(Flag.class);
        this.options = (Option[])method.getAnnotationsByType(Option.class);
        this.arguments = new HashSet<String>(Arrays.asList(arguments));
        this.parsedFlags = new HashSet<String>();
        this.parsedOptions = new HashMap<String, List<String>>();
    }

    public Map<String, List<String>> parseOptions() {
        for (Option option : this.options) {
            this.parseOption(option);
        }
        return this.parsedOptions;
    }

    public Set<String> parseFlags() {
        for (Flag flag : this.flags) {
            this.parseFlag(flag);
        }
        return this.parsedFlags;
    }

    private void parseOption(Option option) {
        String prefix = option.prefix();
        String keySeparator = Pattern.quote(option.keySeparator());
        String valueSeparator = Pattern.quote(option.valueSeparator());
        Iterator<String> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            String argument = iterator.next();
            if (!argument.startsWith(prefix) || option.allowSeparating() && !argument.contains(option.keySeparator())) continue;
            String[] options = argument.substring(prefix.length()).split(keySeparator);
            if (!option.allowSeparating()) {
                if (options.length < 2) continue;
                String value = options[1];
                this.parsedOptions.put(option.value(), Collections.singletonList(value));
                iterator.remove();
                continue;
            }
            String[] values = options[1].split(valueSeparator);
            this.parsedOptions.put(option.value(), Arrays.asList(values));
            iterator.remove();
        }
    }

    private void parseFlag(Flag flag) {
        String prefix = flag.prefix();
        block0: for (String argument : this.arguments) {
            if (!argument.startsWith(prefix)) continue;
            String foundFlag = argument.substring(prefix.length());
            for (String flagName : flag.value()) {
                if (!flagName.equals(foundFlag)) continue;
                this.parsedFlags.add(flagName);
                continue block0;
            }
        }
    }
}

