/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs.utils;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.utils.SelfExpiringMap;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.utils.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SelfExpiringHashMap<K, V>
implements SelfExpiringMap<K, V> {
    private final Map<K, Map.Entry<V, ExpiringData>> map = new HashMap<K, Map.Entry<V, ExpiringData>>();

    @Override
    public V put(K key, V value, long lifeTimeMs) {
        this.map.put(key, Utils.mapEntry(value, new ExpiringData(System.currentTimeMillis(), lifeTimeMs)));
        return value;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, Long.MAX_VALUE);
    }

    @Override
    public boolean containsKey(Object key) {
        Map.Entry<V, ExpiringData> entry = this.map.get(key);
        if (entry == null) {
            return false;
        }
        if (System.currentTimeMillis() - entry.getValue().start < entry.getValue().lifeTimeMs) {
            return this.map.containsKey(key);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Map.Entry<V, ExpiringData> entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        if (System.currentTimeMillis() - entry.getValue().start < entry.getValue().lifeTimeMs) {
            return entry.getKey();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        Map.Entry<V, ExpiringData> entry = this.map.remove(key);
        return entry.getKey();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class ExpiringData {
        private final long start;
        private final long lifeTimeMs;

        ExpiringData(long start, long lifeTimeMs) {
            this.start = start;
            this.lifeTimeMs = lifeTimeMs;
        }
    }
}

