/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.libs.utils;

import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Utils {
    private Utils() {
    }

    public static int getInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    public static double getDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception ignored) {
            return 0.0;
        }
    }

    public static long getLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception ignored) {
            return 0L;
        }
    }

    public static float getFloat(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (Exception ignored) {
            return 0.0f;
        }
    }

    public static <K, V> Map.Entry<K, V> mapEntry(K a, V b) {
        return new AbstractMap.SimpleEntry<K, V>(a, b);
    }

    public static <K, V> Map<K, V> mapOf(K a, V b) {
        return Utils.mapOf(Utils.mapEntry(a, b));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOf(Map.Entry<K, V> ... a) {
        return Arrays.stream(a).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (b, c) -> c));
    }

    public static void handleExceptions(Exception exception) {
        Throwable cause = exception.getCause();
        if (cause == null) {
            exception.printStackTrace();
            return;
        }
        cause.printStackTrace();
    }

    public static Command createCommand(final Command command, final String commandName) {
        return new Command(){

            @Override
            public String name() {
                return commandName;
            }

            @Override
            public String fallbackPrefix() {
                return command.fallbackPrefix();
            }

            @Override
            public String permission() {
                return command.permission();
            }

            @Override
            public String[] aliases() {
                return new String[0];
            }

            @Override
            public String desc() {
                return command.desc();
            }

            @Override
            public String usage() {
                return command.usage();
            }

            @Override
            public int min() {
                return command.min();
            }

            @Override
            public int max() {
                return command.max();
            }

            @Override
            public boolean onlyOp() {
                return command.onlyOp();
            }

            @Override
            public boolean async() {
                return command.async();
            }

            @Override
            public Command.SenderType senderType() {
                return command.senderType();
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return command.annotationType();
            }
        };
    }
}

