/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.listener;

import com.github.sarhatabaot.chunkspawnerlimiter.PluginConfig;
import com.github.sarhatabaot.chunkspawnerlimiter.chunk.ChunkCoord;
import com.github.sarhatabaot.chunkspawnerlimiter.counter.CounterDataManager;
import com.github.sarhatabaot.chunkspawnerlimiter.reflection.WorldReflection;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.RemovalTaskManager;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.RemovalMode;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.jetbrains.annotations.NotNull;

public class ChunkListener
implements Listener {
    private final PluginConfig pluginConfig;
    private final CounterDataManager counterDataManager;
    private final RemovalTaskManager removalTaskManager;

    public ChunkListener(PluginConfig pluginConfig, CounterDataManager counterDataManager, RemovalTaskManager removalTaskManager) {
        this.pluginConfig = pluginConfig;
        this.counterDataManager = counterDataManager;
        this.removalTaskManager = removalTaskManager;
    }

    @EventHandler
    public void onChunkLoad(@NotNull ChunkLoadEvent event) {
        if (!this.pluginConfig.isWorldDisabled(event.getWorld().getName())) {
            return;
        }
        Chunk chunk = event.getChunk();
        ChunkCoord chunkCoord = ChunkCoord.from(chunk);
        this.addEntityLimits(chunk, chunkCoord);
        this.addBlockLimits(chunk, chunkCoord);
        RemovalMode removalMode = this.pluginConfig.getRemovalMode();
        this.removalTaskManager.queueChunkCheck(chunkCoord, removalMode.getEntityRemovalAction());
        if (this.pluginConfig.isActiveInspections()) {
            this.removalTaskManager.scheduleRecheck(chunkCoord, removalMode.getEntityRemovalAction(), this.pluginConfig.getInspectionFrequency());
        }
    }

    @EventHandler
    public void onChunkUnload(@NotNull ChunkUnloadEvent event) {
        if (this.pluginConfig.isWorldDisabled(event.getWorld().getName())) {
            return;
        }
        ChunkCoord chunkCoord = ChunkCoord.from(event.getChunk());
        this.counterDataManager.removeCounterData(chunkCoord);
    }

    private void addEntityLimits(@NotNull Chunk chunk, ChunkCoord chunkCoord) {
        Entity[] entities;
        for (Entity entity : entities = chunk.getEntities()) {
            String entityGroup;
            if (entity instanceof Player && !this.pluginConfig.isKillPlayers()) continue;
            if (this.pluginConfig.hasEntityLimit(entity.getType().name())) {
                this.counterDataManager.getCounterData(chunkCoord).incrementEntity(entity.getType());
            }
            if (!this.pluginConfig.hasEntityLimit(entityGroup = this.pluginConfig.getEntityGroup(entity))) continue;
            this.counterDataManager.getCounterData(chunkCoord).incrementEntityGroup(entityGroup);
        }
    }

    private int chunkCoordsToCoords(int coord) {
        return coord * 16;
    }

    private void addBlockLimits(@NotNull Chunk chunk, ChunkCoord chunkCoord) {
        World world = chunk.getWorld();
        int startX = this.chunkCoordsToCoords(chunk.getX());
        int startZ = this.chunkCoordsToCoords(chunk.getZ());
        int minY = WorldReflection.getWorldMinHeightSafe(world);
        int maxY = world.getMaxHeight();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    Block block = world.getBlockAt(startX + x, y, startZ + z);
                    if (!this.pluginConfig.hasBlockLimit(block.getType().name())) continue;
                    this.counterDataManager.getCounterData(chunkCoord).incrementBlock(block.getType());
                }
            }
        }
    }
}

