/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.listener;

import com.github.sarhatabaot.chunkspawnerlimiter.CSLLogger;
import com.github.sarhatabaot.chunkspawnerlimiter.PluginConfig;
import com.github.sarhatabaot.chunkspawnerlimiter.chunk.ChunkCoord;
import com.github.sarhatabaot.chunkspawnerlimiter.counter.CounterData;
import com.github.sarhatabaot.chunkspawnerlimiter.counter.CounterDataManager;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.Checks;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.RemovalMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.jetbrains.annotations.NotNull;

public class EventListener
implements Listener {
    private final PluginConfig pluginConfig;
    private final CounterDataManager counterDataManager;

    public EventListener(PluginConfig pluginConfig, CounterDataManager counterDataManager) {
        this.pluginConfig = pluginConfig;
        this.counterDataManager = counterDataManager;
    }

    @EventHandler
    public void onBlockPlace(@NotNull BlockPlaceEvent event) {
        if (this.pluginConfig.isWorldDisabled(event.getBlock().getWorld().getName())) {
            return;
        }
        if (!this.pluginConfig.getBlockLimits().containsKey(event.getBlock().getType().name())) {
            CSLLogger.debug("%s block not in block limits.".formatted(event.getBlock().getType().name()));
            return;
        }
        Material material = event.getBlock().getType();
        ChunkCoord chunkCoord = ChunkCoord.from(event.getBlock().getLocation());
        CounterData counterData = this.counterDataManager.getCounterData(chunkCoord);
        if (Checks.isUnderOrEqualToLimit(counterData.getBlockCount(material), this.pluginConfig.getBlockLimits().get(material.name()))) {
            CSLLogger.debug("%s block under block limits (%d/%d)".formatted(material.name(), counterData.getBlockCount(material), this.pluginConfig.getBlockLimits().get(material.name())));
            counterData.incrementBlock(material);
            return;
        }
        RemovalMode removalMode = this.pluginConfig.getRemovalMode();
        removalMode.handleBlock(event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onBlockBreak(@NotNull BlockBreakEvent event) {
        if (this.pluginConfig.isWorldDisabled(event.getBlock().getWorld().getName())) {
            return;
        }
        ChunkCoord chunkCoord = ChunkCoord.from(event.getBlock().getLocation());
        this.counterDataManager.getCounterData(chunkCoord).decrementBlock(event.getBlock().getType());
    }

    @EventHandler
    public void onEntitySpawn(@NotNull EntitySpawnEvent event) {
        if (this.pluginConfig.isWorldDisabled(event.getLocation().getWorld().getName())) {
            return;
        }
        if (!this.pluginConfig.hasEntityLimit(event.getEntity())) {
            CSLLogger.debug("%s entity not in entity limits.".formatted(event.getEntity().getType().name()));
            return;
        }
        EntityType entityType = event.getEntity().getType();
        ChunkCoord chunkCoord = ChunkCoord.from(event.getEntity().getWorld().getChunkAt(event.getEntity().getLocation()));
        CounterData counterData = this.counterDataManager.getCounterData(chunkCoord);
        if (Checks.isUnderOrEqualToLimit(counterData.getEntityCount(entityType), this.pluginConfig.getEntityLimit(event.getEntity()))) {
            CSLLogger.debug("%s entity under entity limits (%d/%d)".formatted(entityType.name(), counterData.getEntityCount(entityType), this.pluginConfig.getEntityLimit(event.getEntity())));
            counterData.incrementEntity(entityType);
            return;
        }
        RemovalMode removalMode = this.pluginConfig.getRemovalMode();
        removalMode.handleEntity(event.getEntity(), (Cancellable)event);
    }

    private void messagePlayers() {
    }

    @EventHandler
    public void onEntityDeath(@NotNull EntityDeathEvent event) {
        if (this.pluginConfig.isWorldDisabled(event.getEntity().getWorld().getName())) {
            return;
        }
        ChunkCoord chunkCoord = ChunkCoord.from(event.getEntity().getWorld().getChunkAt(event.getEntity().getLocation()));
        this.counterDataManager.getCounterData(chunkCoord).decrementEntity(event.getEntityType());
    }

    @EventHandler
    public void onVehicleCreate(@NotNull VehicleCreateEvent event) {
        if (this.pluginConfig.isWorldDisabled(event.getVehicle().getWorld().getName())) {
            return;
        }
        if (!this.pluginConfig.hasEntityLimit((Entity)event.getVehicle())) {
            return;
        }
        EntityType vehicleType = event.getVehicle().getType();
        ChunkCoord chunkCoord = ChunkCoord.from(event.getVehicle().getWorld().getChunkAt(event.getVehicle().getLocation()));
        CounterData counterData = this.counterDataManager.getCounterData(chunkCoord);
        if (Checks.isUnderOrEqualToLimit(counterData.getEntityCount(vehicleType), this.pluginConfig.getEntityLimit((Entity)event.getVehicle()))) {
            counterData.incrementEntity(vehicleType);
            return;
        }
        RemovalMode removalMode = this.pluginConfig.getRemovalMode();
        removalMode.handleEntity((Entity)event.getVehicle(), null);
    }

    @EventHandler
    public void onVehicleDestroy(@NotNull VehicleDestroyEvent event) {
        if (this.pluginConfig.isWorldDisabled(event.getVehicle().getWorld().getName())) {
            return;
        }
        ChunkCoord chunkCoord = ChunkCoord.from(event.getVehicle().getWorld().getChunkAt(event.getVehicle().getLocation()));
        this.counterDataManager.getCounterData(chunkCoord).decrementEntity(event.getVehicle().getType());
    }
}

