/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.reflection;

import java.lang.reflect.Method;
import java.util.Collection;

public final class RaidReflection {
    private static final boolean SUPPORTED;
    private static final Class<?> RAIDER_CLASS;
    private static final Class<?> RAID_CLASS;
    private static final Method GET_WORLD;
    private static final Method GET_RAIDS;
    private static final Method GET_RAIDERS;

    private RaidReflection() {
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static boolean isEntityInRaid(Object entity) {
        if (!SUPPORTED || entity == null || !RAIDER_CLASS.isInstance(entity)) {
            return false;
        }
        try {
            Object world = GET_WORLD.invoke(entity, new Object[0]);
            Collection raids = (Collection)GET_RAIDS.invoke(world, new Object[0]);
            for (Object raid : raids) {
                Collection raiders = (Collection)GET_RAIDERS.invoke(raid, new Object[0]);
                if (!raiders.contains(entity)) continue;
                return true;
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return false;
    }

    static {
        boolean supported;
        Class<?> raider = null;
        Class<?> raid = null;
        Method getWorld = null;
        Method getRaids = null;
        Method getRaiders = null;
        try {
            raider = Class.forName("org.bukkit.entity.Raider");
            raid = Class.forName("org.bukkit.Raid");
            getWorld = raider.getMethod("getWorld", new Class[0]);
            getRaids = raider.getMethod("getWorld", new Class[0]).getReturnType().getMethod("getRaids", new Class[0]);
            getRaiders = raid.getMethod("getRaiders", new Class[0]);
            supported = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            supported = false;
        }
        RAIDER_CLASS = raider;
        RAID_CLASS = raid;
        GET_WORLD = getWorld;
        GET_RAIDS = getRaids;
        GET_RAIDERS = getRaiders;
        SUPPORTED = supported;
    }
}

