/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.reflection;

import java.lang.reflect.Method;
import org.bukkit.World;

public final class WorldReflection {
    private static final boolean SUPPORTED;
    private static final Method GET_MIN_HEIGHT;

    private WorldReflection() {
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static int getWorldMinHeightSafe(World world) {
        if (!SUPPORTED) {
            return 0;
        }
        try {
            return (Integer)GET_MIN_HEIGHT.invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return 0;
        }
    }

    static {
        boolean supported;
        Method getMinHeight = null;
        try {
            getMinHeight = World.class.getMethod("getMinHeight", new Class[0]);
            supported = true;
        }
        catch (NoSuchMethodException e) {
            supported = false;
        }
        GET_MIN_HEIGHT = getMinHeight;
        SUPPORTED = supported;
    }
}

