/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.removal;

import com.github.sarhatabaot.chunkspawnerlimiter.CSLLogger;
import com.github.sarhatabaot.chunkspawnerlimiter.ChunkSpawnerLimiter;
import com.github.sarhatabaot.chunkspawnerlimiter.PluginConfig;
import com.github.sarhatabaot.chunkspawnerlimiter.chunk.ChunkCoord;
import com.github.sarhatabaot.chunkspawnerlimiter.counter.CounterData;
import com.github.sarhatabaot.chunkspawnerlimiter.counter.CounterDataManager;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.Checks;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.ExternalChecks;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class RemovalTaskManager {
    private final Queue<QueuedCheck> pendingChunks = new ConcurrentLinkedQueue<QueuedCheck>();
    private final Set<ChunkCoord> queuedChunks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<QueuedCheck, Long> scheduledRechecks = new ConcurrentHashMap<QueuedCheck, Long>();
    private final CounterDataManager counterDataManager;
    private final ChunkSpawnerLimiter plugin;
    private final PluginConfig pluginConfig;

    public RemovalTaskManager(ChunkSpawnerLimiter plugin, CounterDataManager counterDataManager, PluginConfig pluginConfig) {
        this.plugin = plugin;
        this.counterDataManager = counterDataManager;
        this.pluginConfig = pluginConfig;
        this.startProcessingTask();
    }

    public void scheduleRecheck(ChunkCoord coord, Consumer<Entity> action, long delaySeconds) {
        long nextCheck = System.currentTimeMillis() + delaySeconds * 1000L;
        QueuedCheck check = new QueuedCheck(coord, action);
        this.scheduledRechecks.put(check, nextCheck);
        CSLLogger.debug("Scheduled recheck for chunk %s in %d seconds".formatted(coord, delaySeconds));
    }

    public void queueChunkCheck(ChunkCoord coord, Consumer<Entity> action) {
        if (this.queuedChunks.add(coord)) {
            this.pendingChunks.add(new QueuedCheck(coord, action));
        }
    }

    private void startProcessingTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::processQueue, 20L, 20L);
    }

    private void processQueue() {
        QueuedCheck check;
        while ((check = this.pendingChunks.poll()) != null) {
            this.processChunk(check.coord, check.action);
            this.queuedChunks.remove(check.coord);
        }
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<QueuedCheck, Long>> it = this.scheduledRechecks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<QueuedCheck, Long> entry = it.next();
            if (entry.getValue() > now) continue;
            it.remove();
            this.queueChunkCheck(entry.getKey().coord, entry.getKey().action);
        }
    }

    private Consumer<Entity> getDefaultAction() {
        return this.pluginConfig.getRemovalMode().getEntityRemovalAction();
    }

    public void processChunk(ChunkCoord coord, Consumer<Entity> removalAction) {
        CounterData data = this.counterDataManager.getCounterData(coord);
        if (data == null) {
            return;
        }
        Chunk chunk = coord.getChunk();
        if (chunk == null || !chunk.isLoaded()) {
            return;
        }
        for (EntityType type : data.getTrackedEntityTypes()) {
            List<Entity> entities = Arrays.stream(chunk.getEntities()).filter(e -> e.getType() == type).toList();
            Integer allowed = this.pluginConfig.getEntityLimit(type);
            if (allowed == null) {
                CSLLogger.debug("No limit found for entity type: %s, skipping".formatted(type.name()));
                continue;
            }
            if (entities.size() <= allowed) continue;
            int toRemove = entities.size() - allowed;
            for (int i = 0; i < toRemove; ++i) {
                Entity entity = entities.get(i);
                if (!this.checks(entity)) continue;
                removalAction.accept(entity);
            }
        }
    }

    private boolean checks(Entity entity) {
        return Checks.hasCustomName(entity) || Checks.hasMetaData(entity) || ExternalChecks.hasNbtData(entity) || Checks.isPartOfRaid(entity);
    }

    private record QueuedCheck(ChunkCoord coord, Consumer<Entity> action) {
    }
}

