/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.removal.modes;

import com.github.sarhatabaot.chunkspawnerlimiter.removal.RemovalTaskManager;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.Enforce;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.EnforceKill;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.Kill;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.Prevent;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.Remove;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface RemovalMode
permits Prevent, Remove, Kill, Enforce, EnforceKill {
    public static final Map<String, RemovalMode> MODES = new HashMap<String, RemovalMode>();

    @NotNull
    public String getKey();

    public void handleEntity(@NotNull Entity var1, @Nullable Cancellable var2);

    public void handleBlock(@NotNull Block var1, @NotNull Cancellable var2);

    public Consumer<Entity> getEntityRemovalAction();

    public static void setup(@NotNull RemovalTaskManager removalTaskManager) {
        MODES.put("prevent", new Prevent());
        MODES.put("remove", new Remove(removalTaskManager));
        MODES.put("kill", new Kill(removalTaskManager));
        MODES.put("enforce", new Enforce(removalTaskManager));
        MODES.put("enforce-kill", new EnforceKill(removalTaskManager));
    }

    @NotNull
    public static RemovalMode fromString(@NotNull String mode) {
        return MODES.getOrDefault(mode.toLowerCase(), MODES.get("enforce"));
    }
}

