/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.removal.modes;

import com.github.sarhatabaot.chunkspawnerlimiter.chunk.ChunkCoord;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.RemovalTaskManager;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.RemovalMode;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Remove
implements RemovalMode {
    private final RemovalTaskManager removalTaskManager;

    public Remove(RemovalTaskManager removalTaskManager) {
        this.removalTaskManager = removalTaskManager;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String getKey() {
        return "remove";
    }

    @Override
    public void handleEntity(@NotNull Entity entity, @Nullable Cancellable event) {
        entity.remove();
        ChunkCoord coord = ChunkCoord.from(entity.getLocation().getChunk());
        this.removalTaskManager.queueChunkCheck(coord, this.getEntityRemovalAction());
    }

    @Override
    public void handleBlock(@NotNull Block block, @NotNull Cancellable event) {
        block.setType(Material.AIR);
    }

    @Override
    public Consumer<Entity> getEntityRemovalAction() {
        return e -> {
            if (e instanceof Player) {
                Player player = (Player)e;
                player.setHealth(0.0);
            } else {
                e.remove();
            }
        };
    }
}

