/*
 * Decompiled with CFR 0.152.
 */
package net.nuvarek.mobiglass.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.nuvarek.mobiglass.MobiglassMod;
import net.nuvarek.mobiglass.init.MobiglassModScreens;
import net.nuvarek.mobiglass.network.MenuStateUpdateMessage;
import net.nuvarek.mobiglass.world.inventory.MobiDisplayMenu;
import net.nuvarek.mobiglass.world.inventory.MobiOptionsMenu;
import net.nuvarek.mobiglass.world.inventory.MobiStorageMenu;

public class MobiglassModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"mobiglass");
    public static final RegistryObject<MenuType<MobiOptionsMenu>> MOBI_OPTIONS = REGISTRY.register("mobi_options", () -> IForgeMenuType.create(MobiOptionsMenu::new));
    public static final RegistryObject<MenuType<MobiStorageMenu>> MOBI_STORAGE = REGISTRY.register("mobi_storage", () -> IForgeMenuType.create(MobiStorageMenu::new));
    public static final RegistryObject<MenuType<MobiDisplayMenu>> MOBI_DISPLAY = REGISTRY.register("mobi_display", () -> IForgeMenuType.create(MobiDisplayMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MobiglassMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof MobiglassModScreens.ScreenAccessor) {
                    MobiglassModScreens.ScreenAccessor accessor = (MobiglassModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                MobiglassMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

