/*
 * Decompiled with CFR 0.152.
 */
package tmm_blood.mixin;

import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tmm_blood.ClearParticlesPayload;
import tmm_blood.TMMBlood;

@Mixin(value={GameFunctions.class})
public class GameFunctionsMixin {
    @Inject(method={"killPlayer(Lnet/minecraft/class_1657;ZLnet/minecraft/class_1657;Lnet/minecraft/class_2960;)V"}, at={@At(value="HEAD")})
    private static void onPlayerKill(class_1657 victim, boolean spawnBody, class_1657 killer, class_2960 deathReason, CallbackInfo ci) {
        class_1937 class_19372;
        if (victim != null && (class_19372 = victim.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (spawnBody) {
                class_243 bloodSpawnPos = GameFunctionsMixin.getBloodSpawnPosition(victim, killer);
                GameFunctionsMixin.spawnBloodParticles(serverWorld, bloodSpawnPos, killer, deathReason, victim);
            }
        }
    }

    @Unique
    private static class_243 getBloodSpawnPosition(class_1657 victim, class_1657 killer) {
        class_243 endPos;
        if (killer == null) {
            return victim.method_19538().method_1031(0.0, 1.0, 0.0);
        }
        class_243 lookVec = killer.method_5828(1.0f);
        class_243 killerPos = killer.method_33571();
        class_3966 entityHit = GameFunctionsMixin.raycastEntities(killer, killerPos, endPos = killerPos.method_1019(lookVec.method_1021(20.0)), victim);
        if (entityHit != null) {
            return entityHit.method_17784();
        }
        return victim.method_19538().method_1031(0.0, 1.0, 0.0);
    }

    @Unique
    private static class_3966 raycastEntities(class_1657 killer, class_243 start, class_243 end, class_1657 target) {
        class_238 box = target.method_5829();
        class_243 hitPos = box.method_992(start, end).orElse(null);
        if (hitPos != null) {
            return new class_3966((class_1297)target, hitPos);
        }
        return null;
    }

    @Unique
    private static void spawnBloodParticles(class_3218 world, class_243 pos, class_1657 killer, class_2960 cause, class_1657 victim) {
        try {
            if (Objects.equals(cause, TMM.id((String)"generic"))) {
                world.method_14199((class_2394)TMMBlood.BLOOD_PARTICLE, pos.method_10216(), pos.method_10214(), pos.method_10215(), 10, 0.1, 0.1, 0.1, 0.025);
            } else if (Objects.equals(cause, TMM.id((String)"knife_stab"))) {
                world.method_14199((class_2394)TMMBlood.BLOOD_PARTICLE, pos.method_10216(), pos.method_10214(), pos.method_10215(), 10, 0.2, 0.2, 0.2, 0.05);
            } else if (Objects.equals(cause, TMM.id((String)"gun_shot"))) {
                world.method_14199((class_2394)TMMBlood.BLOOD_PARTICLE, pos.method_10216(), pos.method_10214(), pos.method_10215(), 20, 0.1, 0.05, 0.05, 0.1);
            } else if (Objects.equals(cause, TMM.id((String)"bat_hit"))) {
                world.method_14199((class_2394)TMMBlood.BLOOD_PARTICLE, pos.method_10216(), pos.method_10214(), pos.method_10215(), 5, 0.2, 0.2, 0.2, 0.025);
            } else if (Objects.equals(cause, TMM.id((String)"grenade"))) {
                world.method_14199((class_2394)TMMBlood.BLOOD_PARTICLE, victim.method_23317(), victim.method_23318(), victim.method_23321(), 50, 0.5, 2.0, 0.2, 0.2);
            }
        }
        catch (Exception e) {
            TMMBlood.LOGGER.error("Error spawning blood particles: {}", (Object)e.getMessage());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tryResetTrain(Lnet/minecraft/class_3218;)Z"})
    private static void init(class_3218 serverWorld, CallbackInfoReturnable<Boolean> cir) {
        TMMBlood.LOGGER.info("Train reset detected - clearing blood particles");
        GameFunctionsMixin.onPossibleTrainReset(serverWorld);
    }

    @Unique
    private static void onPossibleTrainReset(class_3218 serverWorld) {
        ClearParticlesPayload payload = new ClearParticlesPayload();
        for (class_3222 player : serverWorld.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }
}

