/*
 * Decompiled with CFR 0.152.
 */
package tmm_blood.particle;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class BloodParticle
extends class_4003 {
    private static final float GRAVITY = 0.04f;
    private int state = 0;
    private int wallDirection = 0;
    private float impactScale = 1.0f;
    private static final Set<BloodParticle> ALL_PARTICLES = Collections.newSetFromMap(new WeakHashMap());

    protected BloodParticle(class_638 world, double x, double y, double z, double vx, double vy, double vz, float scale) {
        super(world, x, y, z, vx, vy, vz);
        this.field_3847 = 24000;
        this.field_17867 = scale;
        this.method_34753(vx, vy, vz);
        this.field_3861 = 0.5f;
        this.field_3842 = 0.0f;
        this.field_3859 = 0.0f;
        this.field_3841 = 1.0f;
        this.state = 0;
        ALL_PARTICLES.add(this);
    }

    public static void clearParticles() {
        for (BloodParticle particle : ALL_PARTICLES) {
            if (!particle.method_3086()) continue;
            particle.method_3085();
        }
        ALL_PARTICLES.clear();
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    protected int method_3068(float tint) {
        return 0xF000F0;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        if (this.state == 0) {
            super.method_3074(vertexConsumer, camera, tickDelta);
            return;
        }
        class_243 cameraPos = camera.method_19326();
        float x = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
        float y = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
        float z = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
        Quaternionf quaternion = new Quaternionf();
        if (this.state == 1) {
            quaternion.rotationX((float)Math.toRadians(90.0));
            y += 0.001f;
        } else if (this.state == 2) {
            switch (this.wallDirection) {
                case 1: {
                    quaternion.rotationY((float)Math.toRadians(180.0));
                    z -= 0.0635f;
                    break;
                }
                case 2: {
                    quaternion.rotationY((float)Math.toRadians(0.0));
                    z += 0.0635f;
                    break;
                }
                case 3: {
                    quaternion.rotationY((float)Math.toRadians(-90.0));
                    x -= 0.0635f;
                    break;
                }
                case 4: {
                    quaternion.rotationY((float)Math.toRadians(90.0));
                    x += 0.0635f;
                }
            }
        }
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float scale = this.method_18132(tickDelta) * this.impactScale;
        for (int i = 0; i < 4; ++i) {
            Vector3f vertex = vertices[i];
            vertex.rotate((Quaternionfc)quaternion);
            vertex.mul(scale);
            vertex.add(x, y, z);
        }
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int light = this.method_3068(tickDelta);
        vertexConsumer.method_22912(vertices[0].x(), vertices[0].y(), vertices[0].z()).method_22913(maxU, maxV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        vertexConsumer.method_22912(vertices[1].x(), vertices[1].y(), vertices[1].z()).method_22913(maxU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        vertexConsumer.method_22912(vertices[2].x(), vertices[2].y(), vertices[2].z()).method_22913(minU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        vertexConsumer.method_22912(vertices[3].x(), vertices[3].y(), vertices[3].z()).method_22913(minU, maxV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
    }

    public void method_3070() {
        double prevVelX = this.field_3852;
        double prevVelY = this.field_3869;
        double prevVelZ = this.field_3850;
        if (this.state == 0) {
            this.field_3869 -= (double)0.04f;
        }
        if (this.state == 1 || this.state == 2) {
            this.field_3852 = 0.0;
            this.field_3869 = 0.0;
            this.field_3850 = 0.0;
        }
        super.method_3070();
        if (this.state == 0) {
            if (this.field_3845) {
                this.state = 1;
                double impactVelocity = Math.sqrt(prevVelX * prevVelX + prevVelY * prevVelY + prevVelZ * prevVelZ);
                this.impactScale = 1.0f + (float)Math.min(impactVelocity * 1.5, 2.0);
                this.field_3851.method_8486(this.field_3874, this.field_3854, this.field_3871, class_3417.field_28035, class_3419.field_15256, (float)impactVelocity * 2.0f, 2.0f, true);
            } else if (this.field_3862) {
                boolean zStopped;
                boolean xStopped = Math.abs(prevVelX) > 0.01 && Math.abs(this.field_3852) < 0.001;
                boolean bl = zStopped = Math.abs(prevVelZ) > 0.01 && Math.abs(this.field_3850) < 0.001;
                if (xStopped || zStopped) {
                    double impactVelocity = Math.sqrt(prevVelX * prevVelX + prevVelY * prevVelY + prevVelZ * prevVelZ);
                    this.impactScale = 1.0f + (float)Math.min(impactVelocity * 1.0, 2.0);
                    this.state = 2;
                    if (xStopped && !zStopped) {
                        this.wallDirection = prevVelX > 0.0 ? 4 : 3;
                    } else if (zStopped && !xStopped) {
                        this.wallDirection = prevVelZ > 0.0 ? 2 : 1;
                    } else if (xStopped && zStopped) {
                        this.wallDirection = Math.abs(prevVelX) > Math.abs(prevVelZ) ? (prevVelX > 0.0 ? 4 : 3) : (prevVelZ > 0.0 ? 2 : 1);
                    }
                }
            }
        }
        this.field_3861 = 0.5f - Math.min((float)this.field_3866, 1200.0f) / 1200.0f / 4.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 sprites;

        public Factory(class_4002 sprites) {
            this.sprites = sprites;
        }

        public class_703 createParticle(class_2400 type, class_638 world, double x, double y, double z, double vx, double vy, double vz) {
            BloodParticle particle = new BloodParticle(world, x, y, z, vx, vy, vz, 0.5f);
            particle.method_18140(this.sprites);
            return particle;
        }
    }
}

