package thelm.techrebornjei.addon.advancedreborn;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.pitan76.advancedreborn.Blocks;
import net.pitan76.advancedreborn.Recipes;
import net.pitan76.advancedreborn.gui.GuiCanningMachine;
import net.pitan76.advancedreborn.gui.GuiCentrifugalExtractor;
import net.pitan76.advancedreborn.gui.GuiInductionFurnace;
import net.pitan76.advancedreborn.gui.GuiRotaryGrinder;
import net.pitan76.advancedreborn.gui.GuiSingularityCompressor;
import reborncore.common.crafting.RebornRecipe;
import thelm.techrebornjei.TechRebornJEI;
import thelm.techrebornjei.gui.render.RecipeClickAreaRenderable;
import thelm.techrebornjei.recipe.category.TwoItemToItemRecipeCategory;

public class AdvancedRebornJEI implements IModPlugin {

	public static final class_2960 UID = new class_2960("techrebornjei:advancedreborn");

	public static final RecipeType<RebornRecipe> CANNING_MACHINE = TechRebornJEI.createRecipeType(Recipes.CANNING_MACHINE);

	@Override
	public class_2960 getPluginUid() {
		return UID;
	}

	@Override
	public void registerCategories(IRecipeCategoryRegistration registration) {
		registration.addRecipeCategories(new TwoItemToItemRecipeCategory<>(CANNING_MACHINE));
	}

	@Override
	public void registerRecipes(IRecipeRegistration registration) {
		class_1863 recipeManager = class_310.method_1551().field_1687.method_8433();
		registration.addRecipes(CANNING_MACHINE, recipeManager.method_30027(Recipes.CANNING_MACHINE));
	}

	@Override
	public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
		registration.addRecipeCatalyst(new class_1799(Blocks.CANNING_MACHINE), CANNING_MACHINE);

		registration.addRecipeCatalyst(new class_1799(Blocks.ROTARY_GRINDER), TechRebornJEI.GRINDER);
		registration.addRecipeCatalyst(new class_1799(Blocks.CENTRIFUGAL_EXTRACTOR), TechRebornJEI.EXTRACTOR);
		registration.addRecipeCatalyst(new class_1799(Blocks.SINGULARITY_COMPRESSOR), TechRebornJEI.COMPRESSOR);

		registration.addRecipeCatalyst(new class_1799(Blocks.INDUCTION_FURNACE), RecipeTypes.SMELTING);
	}

	@Override
	public void registerGuiHandlers(IGuiHandlerRegistration registration) {
		registration.addRecipeClickArea(GuiCanningMachine.class, 158, 5, 12, 12, CANNING_MACHINE);

		registration.addRecipeClickArea(GuiRotaryGrinder.class, 158, 5, 12, 12, TechRebornJEI.GRINDER);
		registration.addRecipeClickArea(GuiCentrifugalExtractor.class, 158, 5, 12, 12, TechRebornJEI.EXTRACTOR);
		registration.addRecipeClickArea(GuiSingularityCompressor.class, 158, 5, 12, 12, TechRebornJEI.COMPRESSOR);

		registration.addRecipeClickArea(GuiInductionFurnace.class, 158, 5, 12, 12, RecipeTypes.SMELTING);

		RecipeClickAreaRenderable.addEntry(GuiCanningMachine.class);

		RecipeClickAreaRenderable.addEntry(GuiRotaryGrinder.class);
		RecipeClickAreaRenderable.addEntry(GuiCentrifugalExtractor.class);
		RecipeClickAreaRenderable.addEntry(GuiSingularityCompressor.class);

		RecipeClickAreaRenderable.addEntry(GuiInductionFurnace.class);
	}
}
