package thelm.techrebornjei.recipe.category;

import java.util.List;

import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import reborncore.common.crafting.RebornRecipe;
import thelm.techrebornjei.gui.render.EnergyDisplayDrawable;

public abstract class AbstractRebornEnergyRecipeCategory<R extends RebornRecipe> extends AbstractRebornRecipeCategory<R> {

	public AbstractRebornEnergyRecipeCategory(RecipeType<R> recipeType) {
		super(recipeType);
	}

	public AbstractRebornEnergyRecipeCategory(RecipeType<R> recipeType, class_2561 title) {
		super(recipeType, title);
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder builder, R recipe, IFocusGroup focuses) {
		builder.addDrawable(EnergyDisplayDrawable.DOWN, 3, 3);
	}

	@Override
	public void getTooltip(ITooltipBuilder tooltip, R recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
		if(EnergyDisplayDrawable.isMouseOver(3, 3, mouseX, mouseY)) {
			tooltip.addAll(List.of(
					class_2561.method_43471("techreborn.jei.recipe.energy"),
					class_2561.method_43469("techreborn.jei.recipe.running.cost", "E", recipe.getPower()).method_27692(class_124.field_1080),
					class_2561.method_43469("techreborn.jei.recipe.generator.total", recipe.getPower() * recipe.getTime()).method_27692(class_124.field_1080),
					class_2561.method_43470(jeiHelpers().getModIdHelper().getFormattedModNameForModId("techreborn"))));
		}
	}
}
