package thelm.techrebornjei.recipe.category;

import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import thelm.techrebornjei.gui.render.EnergyDisplayDrawable;
import thelm.techrebornjei.gui.render.ProgressBarDrawable;

public class FusionReactorRecipeCategory extends TwoItemToItemCenterRecipeCategory<FusionReactorRecipe> {

	public FusionReactorRecipeCategory(RecipeType<FusionReactorRecipe> recipeType) {
		super(recipeType);
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder builder, FusionReactorRecipe recipe, IFocusGroup focuses) {
		builder.addDrawable(recipe.getPower() < 0 ? EnergyDisplayDrawable.DOWN : EnergyDisplayDrawable.UP, 3, 3);
		builder.addDrawable(ProgressBarDrawable.right(recipe), 45, 23);
		builder.addDrawable(ProgressBarDrawable.left(recipe), 95, 23);
	}

	@Override
	public void draw(FusionReactorRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
		class_327 font = font();
		class_2561 component = getTimeComponent(recipe);
		guiGraphics.method_51439(font, component, getWidth() - font.method_27525(component), 0, 0xFF808080, false);
	}
}
