package thelm.techrebornjei;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import reborncore.client.gui.builder.GuiBase;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.fluid.container.ItemFluidInfo;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.recipe.recipes.AssemblingMachineRecipe;
import techreborn.api.recipe.recipes.BlastFurnaceRecipe;
import techreborn.api.recipe.recipes.CentrifugeRecipe;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.api.recipe.recipes.IndustrialGrinderRecipe;
import techreborn.api.recipe.recipes.IndustrialSawmillRecipe;
import techreborn.api.recipe.recipes.RollingMachineRecipe;
import techreborn.client.gui.DataDrivenGui;
import techreborn.client.gui.GuiAlloyFurnace;
import techreborn.client.gui.GuiAlloySmelter;
import techreborn.client.gui.GuiAssemblingMachine;
import techreborn.client.gui.GuiAutoCrafting;
import techreborn.client.gui.GuiBlastFurnace;
import techreborn.client.gui.GuiCentrifuge;
import techreborn.client.gui.GuiChemicalReactor;
import techreborn.client.gui.GuiCompressor;
import techreborn.client.gui.GuiDieselGenerator;
import techreborn.client.gui.GuiDistillationTower;
import techreborn.client.gui.GuiElectricFurnace;
import techreborn.client.gui.GuiExtractor;
import techreborn.client.gui.GuiFluidReplicator;
import techreborn.client.gui.GuiFusionReactor;
import techreborn.client.gui.GuiGasTurbine;
import techreborn.client.gui.GuiGenerator;
import techreborn.client.gui.GuiImplosionCompressor;
import techreborn.client.gui.GuiIndustrialElectrolyzer;
import techreborn.client.gui.GuiIndustrialGrinder;
import techreborn.client.gui.GuiIndustrialSawmill;
import techreborn.client.gui.GuiIronFurnace;
import techreborn.client.gui.GuiPlasmaGenerator;
import techreborn.client.gui.GuiRollingMachine;
import techreborn.client.gui.GuiScrapboxinator;
import techreborn.client.gui.GuiSemifluidGenerator;
import techreborn.client.gui.GuiSolidCanningMachine;
import techreborn.client.gui.GuiThermalGenerator;
import techreborn.client.gui.GuiVacuumFreezer;
import techreborn.client.gui.GuiWireMill;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;
import thelm.techrebornjei.addon.advancedreborn.AdvancedRebornJEI;
import thelm.techrebornjei.gui.handler.GuiBaseExtraAreaHandler;
import thelm.techrebornjei.gui.render.RecipeClickAreaRenderable;
import thelm.techrebornjei.recipe.category.FluidGeneratorRecipeCategory;
import thelm.techrebornjei.recipe.category.FusionReactorRecipeCategory;
import thelm.techrebornjei.recipe.category.ItemFluidToFourItemRecipeCategory;
import thelm.techrebornjei.recipe.category.ItemFluidToThreeItemRecipeCategory;
import thelm.techrebornjei.recipe.category.ItemToFluidRecipeCategory;
import thelm.techrebornjei.recipe.category.ItemToItemRecipeCategory;
import thelm.techrebornjei.recipe.category.RollingMachineRecipeCategory;
import thelm.techrebornjei.recipe.category.TwoItemToFourItemCircleRecipeCategory;
import thelm.techrebornjei.recipe.category.TwoItemToFourItemRecipeCategory;
import thelm.techrebornjei.recipe.category.TwoItemToItemCenterRecipeCategory;
import thelm.techrebornjei.recipe.category.TwoItemToItemRecipeCategory;
import thelm.techrebornjei.recipe.category.TwoItemToThreeItemRecipeCategory;
import thelm.techrebornjei.recipe.category.TwoItemToTwoItemRecipeCategory;
import thelm.techrebornjei.recipe.transfer.BuiltScreenHandlerTransferInfo;

public class TechRebornJEI implements IModPlugin {

	public static final class_2960 UID = new class_2960("techrebornjei:techreborn");

	public static IJeiHelpers jeiHelpers;
	public static IJeiRuntime jeiRuntime;

	public static final RecipeType<RebornRecipe> ALLOY_SMELTER = createRecipeType(ModRecipes.ALLOY_SMELTER);
	public static final RecipeType<AssemblingMachineRecipe> ASSEMBLING_MACHINE = createRecipeType(ModRecipes.ASSEMBLING_MACHINE, AssemblingMachineRecipe.class);
	public static final RecipeType<BlastFurnaceRecipe> BLAST_FURNACE = createRecipeType(ModRecipes.BLAST_FURNACE, BlastFurnaceRecipe.class);
	public static final RecipeType<CentrifugeRecipe> CENTRIFUGE = createRecipeType(ModRecipes.CENTRIFUGE, CentrifugeRecipe.class);
	public static final RecipeType<RebornRecipe> CHEMICAL_REACTOR = createRecipeType(ModRecipes.CHEMICAL_REACTOR);
	public static final RecipeType<RebornRecipe> COMPRESSOR = createRecipeType(ModRecipes.COMPRESSOR);
	public static final RecipeType<RebornRecipe> DISTILLATION_TOWER = createRecipeType(ModRecipes.DISTILLATION_TOWER);
	public static final RecipeType<RebornRecipe> EXTRACTOR = createRecipeType(ModRecipes.EXTRACTOR);
	public static final RecipeType<FluidReplicatorRecipe> FLUID_REPLICATOR = createRecipeType(ModRecipes.FLUID_REPLICATOR, FluidReplicatorRecipe.class);
	public static final RecipeType<FusionReactorRecipe> FUSION_REACTOR = createRecipeType(ModRecipes.FUSION_REACTOR, FusionReactorRecipe.class);
	public static final RecipeType<RebornRecipe> GRINDER = createRecipeType(ModRecipes.GRINDER);
	public static final RecipeType<RebornRecipe> IMPLOSION_COMPRESSOR = createRecipeType(ModRecipes.IMPLOSION_COMPRESSOR);
	public static final RecipeType<RebornRecipe> INDUSTRIAL_ELECTROLYZER = createRecipeType(ModRecipes.INDUSTRIAL_ELECTROLYZER);
	public static final RecipeType<IndustrialGrinderRecipe> INDUSTRIAL_GRINDER = createRecipeType(ModRecipes.INDUSTRIAL_GRINDER, IndustrialGrinderRecipe.class);
	public static final RecipeType<IndustrialSawmillRecipe> INDUSTRIAL_SAWMILL = createRecipeType(ModRecipes.INDUSTRIAL_SAWMILL, IndustrialSawmillRecipe.class);
	public static final RecipeType<RollingMachineRecipe> ROLLING_MACHINE = createRecipeType(ModRecipes.ROLLING_MACHINE, RollingMachineRecipe.class);
	public static final RecipeType<RebornRecipe> SCRAPBOX = createRecipeType(ModRecipes.SCRAPBOX);
	public static final RecipeType<RebornRecipe> SOLID_CANNING_MACHINE = createRecipeType(ModRecipes.SOLID_CANNING_MACHINE);
	public static final RecipeType<RebornRecipe> VACUUM_FREEZER = createRecipeType(ModRecipes.VACUUM_FREEZER);
	public static final RecipeType<RebornRecipe> WIRE_MILL = createRecipeType(ModRecipes.WIRE_MILL);

	public static final RecipeType<FluidGeneratorRecipe> THERMAL_GENERATOR = createFluidGeneratorRecipeType(TRContent.Machine.THERMAL_GENERATOR);
	public static final RecipeType<FluidGeneratorRecipe> GAS_GENERATOR = createFluidGeneratorRecipeType(TRContent.Machine.GAS_TURBINE);
	public static final RecipeType<FluidGeneratorRecipe> DIESEL_GENERATOR = createFluidGeneratorRecipeType(TRContent.Machine.DIESEL_GENERATOR);
	public static final RecipeType<FluidGeneratorRecipe> SEMI_FLUID_GENERATOR = createFluidGeneratorRecipeType(TRContent.Machine.SEMI_FLUID_GENERATOR);
	public static final RecipeType<FluidGeneratorRecipe> PLASMA_GENERATOR = createFluidGeneratorRecipeType(TRContent.Machine.PLASMA_GENERATOR);

	public static final List<IModPlugin> ADDONS = new ArrayList<>();

	public TechRebornJEI() {
		if(FabricLoader.getInstance().isModLoaded("advanced_reborn")) {
			ADDONS.add(new AdvancedRebornJEI());
		}
	}

	@Override
	public class_2960 getPluginUid() {
		return UID;
	}

	@Override
	public void registerItemSubtypes(ISubtypeRegistration registration) {
		registration.registerSubtypeInterpreter(TRContent.CELL, new IIngredientSubtypeInterpreter<class_1799>() {
			@Override
			public String apply(class_1799 ingredient, UidContext context) {
				if(ingredient.method_7909() instanceof ItemFluidInfo info) {
					return class_2378.field_11154.method_10221(info.getFluid(ingredient)).toString();
				}
				return "";
			}
		});

		ADDONS.forEach(addon -> addon.registerItemSubtypes(registration));
	}

	@Override
	public void registerCategories(IRecipeCategoryRegistration registration) {
		jeiHelpers = registration.getJeiHelpers();

		registration.addRecipeCategories(new TwoItemToItemCenterRecipeCategory<>(ALLOY_SMELTER));
		registration.addRecipeCategories(new TwoItemToItemRecipeCategory<>(ASSEMBLING_MACHINE));
		registration.addRecipeCategories(new TwoItemToTwoItemRecipeCategory<>(BLAST_FURNACE));
		registration.addRecipeCategories(new TwoItemToFourItemCircleRecipeCategory<>(CENTRIFUGE));
		registration.addRecipeCategories(new TwoItemToItemCenterRecipeCategory<>(CHEMICAL_REACTOR));
		registration.addRecipeCategories(new ItemToItemRecipeCategory<>(COMPRESSOR));
		registration.addRecipeCategories(new TwoItemToThreeItemRecipeCategory<>(DISTILLATION_TOWER));
		registration.addRecipeCategories(new ItemToItemRecipeCategory<>(EXTRACTOR));
		registration.addRecipeCategories(new ItemToFluidRecipeCategory<>(FLUID_REPLICATOR));
		registration.addRecipeCategories(new FusionReactorRecipeCategory(FUSION_REACTOR));
		registration.addRecipeCategories(new ItemToItemRecipeCategory<>(GRINDER));
		registration.addRecipeCategories(new TwoItemToTwoItemRecipeCategory<>(IMPLOSION_COMPRESSOR));
		registration.addRecipeCategories(new TwoItemToFourItemRecipeCategory<>(INDUSTRIAL_ELECTROLYZER));
		registration.addRecipeCategories(new ItemFluidToFourItemRecipeCategory<>(INDUSTRIAL_GRINDER));
		registration.addRecipeCategories(new ItemFluidToThreeItemRecipeCategory<>(INDUSTRIAL_SAWMILL));
		registration.addRecipeCategories(new RollingMachineRecipeCategory(ROLLING_MACHINE));
		registration.addRecipeCategories(new ItemToItemRecipeCategory<>(SCRAPBOX));
		registration.addRecipeCategories(new TwoItemToItemCenterRecipeCategory<>(SOLID_CANNING_MACHINE));
		registration.addRecipeCategories(new ItemToItemRecipeCategory<>(VACUUM_FREEZER));
		registration.addRecipeCategories(new ItemToItemRecipeCategory<>(WIRE_MILL));

		registration.addRecipeCategories(new FluidGeneratorRecipeCategory(THERMAL_GENERATOR));
		registration.addRecipeCategories(new FluidGeneratorRecipeCategory(GAS_GENERATOR));
		registration.addRecipeCategories(new FluidGeneratorRecipeCategory(DIESEL_GENERATOR));
		registration.addRecipeCategories(new FluidGeneratorRecipeCategory(SEMI_FLUID_GENERATOR));
		registration.addRecipeCategories(new FluidGeneratorRecipeCategory(PLASMA_GENERATOR));

		ADDONS.forEach(addon -> addon.registerCategories(registration));
	}

	@Override
	public void registerRecipes(IRecipeRegistration registration) {
		class_1863 recipeManager = class_310.method_1551().field_1687.method_8433();
		registration.addRecipes(ALLOY_SMELTER, recipeManager.method_30027(ModRecipes.ALLOY_SMELTER));
		registration.addRecipes(ASSEMBLING_MACHINE, recipeManager.method_30027(ModRecipes.ASSEMBLING_MACHINE));
		registration.addRecipes(BLAST_FURNACE, recipeManager.method_30027(ModRecipes.BLAST_FURNACE));
		registration.addRecipes(CENTRIFUGE, recipeManager.method_30027(ModRecipes.CENTRIFUGE));
		registration.addRecipes(CHEMICAL_REACTOR, recipeManager.method_30027(ModRecipes.CHEMICAL_REACTOR));
		registration.addRecipes(COMPRESSOR, recipeManager.method_30027(ModRecipes.COMPRESSOR));
		registration.addRecipes(DISTILLATION_TOWER, recipeManager.method_30027(ModRecipes.DISTILLATION_TOWER));
		registration.addRecipes(EXTRACTOR, recipeManager.method_30027(ModRecipes.EXTRACTOR));
		registration.addRecipes(FLUID_REPLICATOR, recipeManager.method_30027(ModRecipes.FLUID_REPLICATOR));
		registration.addRecipes(FUSION_REACTOR, recipeManager.method_30027(ModRecipes.FUSION_REACTOR));
		registration.addRecipes(GRINDER, recipeManager.method_30027(ModRecipes.GRINDER));
		registration.addRecipes(IMPLOSION_COMPRESSOR, recipeManager.method_30027(ModRecipes.IMPLOSION_COMPRESSOR));
		registration.addRecipes(INDUSTRIAL_ELECTROLYZER, recipeManager.method_30027(ModRecipes.INDUSTRIAL_ELECTROLYZER));
		registration.addRecipes(INDUSTRIAL_GRINDER, recipeManager.method_30027(ModRecipes.INDUSTRIAL_GRINDER));
		registration.addRecipes(INDUSTRIAL_SAWMILL, recipeManager.method_30027(ModRecipes.INDUSTRIAL_SAWMILL));
		registration.addRecipes(ROLLING_MACHINE, recipeManager.method_30027(ModRecipes.ROLLING_MACHINE));
		registration.addRecipes(SCRAPBOX, recipeManager.method_30027(ModRecipes.SCRAPBOX));
		registration.addRecipes(SOLID_CANNING_MACHINE, recipeManager.method_30027(ModRecipes.SOLID_CANNING_MACHINE));
		registration.addRecipes(VACUUM_FREEZER, recipeManager.method_30027(ModRecipes.VACUUM_FREEZER));
		registration.addRecipes(WIRE_MILL, recipeManager.method_30027(ModRecipes.WIRE_MILL));

		registration.addRecipes(THERMAL_GENERATOR, getFluidGeneratorRecipes(EFluidGenerator.THERMAL));
		registration.addRecipes(GAS_GENERATOR, getFluidGeneratorRecipes(EFluidGenerator.GAS));
		registration.addRecipes(DIESEL_GENERATOR, getFluidGeneratorRecipes(EFluidGenerator.DIESEL));
		registration.addRecipes(SEMI_FLUID_GENERATOR, getFluidGeneratorRecipes(EFluidGenerator.SEMIFLUID));
		registration.addRecipes(PLASMA_GENERATOR, getFluidGeneratorRecipes(EFluidGenerator.PLASMA));

		ADDONS.forEach(addon -> addon.registerRecipes(registration));
	}

	@Override
	public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
		registration.addRecipeTransferHandler(new BuiltScreenHandlerTransferInfo<>("rollingmachine", ROLLING_MACHINE, IntStream.range(0, 9)));
		registration.addRecipeTransferHandler(new BuiltScreenHandlerTransferInfo<>("autocraftingtable", RecipeTypes.CRAFTING, IntStream.range(0, 9)));

		ADDONS.forEach(addon -> addon.registerRecipeTransferHandlers(registration));
	}

	@Override
	public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.IRON_ALLOY_FURNACE), ALLOY_SMELTER, RecipeTypes.FUELING);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.ALLOY_SMELTER), ALLOY_SMELTER);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.ASSEMBLY_MACHINE), ASSEMBLING_MACHINE);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.INDUSTRIAL_BLAST_FURNACE), BLAST_FURNACE);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.INDUSTRIAL_CENTRIFUGE), CENTRIFUGE);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.CHEMICAL_REACTOR), CHEMICAL_REACTOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.COMPRESSOR), COMPRESSOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.DISTILLATION_TOWER), DISTILLATION_TOWER);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.EXTRACTOR), EXTRACTOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.FLUID_REPLICATOR), FLUID_REPLICATOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.FUSION_CONTROL_COMPUTER), FUSION_REACTOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.GRINDER), GRINDER);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.IMPLOSION_COMPRESSOR), IMPLOSION_COMPRESSOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.INDUSTRIAL_ELECTROLYZER), INDUSTRIAL_ELECTROLYZER);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.INDUSTRIAL_GRINDER), INDUSTRIAL_GRINDER);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.INDUSTRIAL_SAWMILL), INDUSTRIAL_SAWMILL);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.ROLLING_MACHINE), ROLLING_MACHINE);
		registration.addRecipeCatalyst(new class_1799(TRContent.SCRAP_BOX), SCRAPBOX);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.SCRAPBOXINATOR), SCRAPBOX);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.SOLID_CANNING_MACHINE), SOLID_CANNING_MACHINE);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.VACUUM_FREEZER), VACUUM_FREEZER);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.WIRE_MILL), WIRE_MILL);

		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.THERMAL_GENERATOR), THERMAL_GENERATOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.GAS_TURBINE), GAS_GENERATOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.DIESEL_GENERATOR), DIESEL_GENERATOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.SEMI_FLUID_GENERATOR), SEMI_FLUID_GENERATOR);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.PLASMA_GENERATOR), PLASMA_GENERATOR);

		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.AUTO_CRAFTING_TABLE), RecipeTypes.CRAFTING);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.IRON_FURNACE), RecipeTypes.SMELTING, RecipeTypes.FUELING);
		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.ELECTRIC_FURNACE), RecipeTypes.SMELTING);

		registration.addRecipeCatalyst(new class_1799(TRContent.Machine.SOLID_FUEL_GENERATOR), RecipeTypes.FUELING);

		ADDONS.forEach(addon -> addon.registerRecipeCatalysts(registration));
	}

	@Override
	public void registerGuiHandlers(IGuiHandlerRegistration registration) {
		registration.addRecipeClickArea(GuiAlloyFurnace.class, 158, 5, 12, 12, ALLOY_SMELTER, RecipeTypes.FUELING);
		registration.addRecipeClickArea(GuiAlloySmelter.class, 158, 5, 12, 12, ALLOY_SMELTER);
		registration.addRecipeClickArea(GuiAssemblingMachine.class, 158, 5, 12, 12, ASSEMBLING_MACHINE);
		registration.addRecipeClickArea(GuiBlastFurnace.class, 158, 5, 12, 12, BLAST_FURNACE);
		registration.addRecipeClickArea(GuiCentrifuge.class, 158, 5, 12, 12, CENTRIFUGE);
		registration.addRecipeClickArea(GuiChemicalReactor.class, 158, 5, 12, 12, CHEMICAL_REACTOR);
		registration.addRecipeClickArea(GuiCompressor.class, 158, 5, 12, 12, COMPRESSOR);
		registration.addRecipeClickArea(GuiDistillationTower.class, 158, 5, 12, 12, DISTILLATION_TOWER);
		registration.addRecipeClickArea(GuiExtractor.class, 158, 5, 12, 12, EXTRACTOR);
		registration.addRecipeClickArea(GuiFluidReplicator.class, 158, 5, 12, 12, FLUID_REPLICATOR);
		registration.addRecipeClickArea(GuiFusionReactor.class, 158, 5, 12, 12, FUSION_REACTOR);
		registration.addRecipeClickArea(DataDrivenGui.class, 158, 5, 12, 12, GRINDER);
		registration.addRecipeClickArea(GuiImplosionCompressor.class, 158, 5, 12, 12, IMPLOSION_COMPRESSOR);
		registration.addRecipeClickArea(GuiIndustrialElectrolyzer.class, 158, 5, 12, 12, INDUSTRIAL_ELECTROLYZER);
		registration.addRecipeClickArea(GuiIndustrialGrinder.class, 158, 5, 12, 12, INDUSTRIAL_GRINDER);
		registration.addRecipeClickArea(GuiIndustrialSawmill.class, 158, 5, 12, 12, INDUSTRIAL_SAWMILL);
		registration.addRecipeClickArea(GuiRollingMachine.class, 158, 5, 12, 12, ROLLING_MACHINE);
		registration.addRecipeClickArea(GuiScrapboxinator.class, 158, 5, 12, 12, SCRAPBOX);
		registration.addRecipeClickArea(GuiSolidCanningMachine.class, 158, 5, 12, 12, SOLID_CANNING_MACHINE);
		registration.addRecipeClickArea(GuiVacuumFreezer.class, 158, 5, 12, 12, VACUUM_FREEZER);
		registration.addRecipeClickArea(GuiWireMill.class, 158, 5, 12, 12, WIRE_MILL);

		registration.addRecipeClickArea(GuiThermalGenerator.class, 158, 5, 12, 12, THERMAL_GENERATOR);
		registration.addRecipeClickArea(GuiGasTurbine.class, 158, 5, 12, 12, GAS_GENERATOR);
		registration.addRecipeClickArea(GuiDieselGenerator.class, 158, 5, 12, 12, DIESEL_GENERATOR);
		registration.addRecipeClickArea(GuiSemifluidGenerator.class, 158, 5, 12, 12, SEMI_FLUID_GENERATOR);
		registration.addRecipeClickArea(GuiPlasmaGenerator.class, 158, 5, 12, 12, PLASMA_GENERATOR);

		registration.addRecipeClickArea(GuiAutoCrafting.class, 158, 18, 12, 12, RecipeTypes.CRAFTING);
		registration.addRecipeClickArea(GuiIronFurnace.class, 158, 5, 12, 12, RecipeTypes.SMELTING, RecipeTypes.FUELING);
		registration.addRecipeClickArea(GuiElectricFurnace.class, 158, 5, 12, 12, RecipeTypes.SMELTING);

		registration.addRecipeClickArea(GuiGenerator.class, 158, 5, 12, 12, RecipeTypes.FUELING);

		registration.addGenericGuiContainerHandler(GuiBase.class, new GuiBaseExtraAreaHandler());

		RecipeClickAreaRenderable.clearEntries();

		RecipeClickAreaRenderable.addEntry(GuiAlloyFurnace.class);
		RecipeClickAreaRenderable.addEntry(DataDrivenGui.class);
		RecipeClickAreaRenderable.addEntry(GuiAutoCrafting.class, 158, 18);
		RecipeClickAreaRenderable.addEntry(GuiIronFurnace.class);

		ADDONS.forEach(addon -> addon.registerGuiHandlers(registration));
	}

	@Override
	public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
		TechRebornJEI.jeiRuntime = jeiRuntime;

		ADDONS.forEach(addon -> addon.onRuntimeAvailable(jeiRuntime));
	}

	public static RecipeType<RebornRecipe> createRecipeType(RebornRecipeType<RebornRecipe> rebornRecipeType) {
		return new RecipeType<>(rebornRecipeType.name(), RebornRecipe.class);
	}

	public static <R extends RebornRecipe> RecipeType<R> createRecipeType(RebornRecipeType<R> rebornRecipeType, Class<R> rebornRecipeClass) {
		return new RecipeType<>(rebornRecipeType.name(), rebornRecipeClass);
	}

	public static RecipeType<FluidGeneratorRecipe> createFluidGeneratorRecipeType(TRContent.Machine machine) {
		return RecipeType.create("techreborn", machine.name, FluidGeneratorRecipe.class);
	}

	public static List<FluidGeneratorRecipe> getFluidGeneratorRecipes(EFluidGenerator generator) {
		return GeneratorRecipeHelper.getFluidRecipesForGenerator(generator).getRecipes().stream().
				sorted(Comparator.comparing(recipe -> class_2378.field_11154.method_10221(recipe.fluid()))).toList();
	}
}
