package thelm.techrebornjei.recipe.category;

import java.util.List;

import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import reborncore.common.crafting.RebornRecipe;

public abstract class AbstractRebornRecipeCategory<R extends RebornRecipe> extends AbstractRecipeCategory<R> {

	public AbstractRebornRecipeCategory(RecipeType<R> recipeType, class_2561 title) {
		super(recipeType, title);
	}

	public AbstractRebornRecipeCategory(RecipeType<R> recipeType) {
		super(recipeType);
	}

	public List<class_1799> getInput(RebornRecipe recipe, int index) {
		if(index >= 0 && index < recipe.getRebornIngredients().size()) {
			return recipe.getRebornIngredients().get(index).getPreviewStacks();
		}
		return List.of();
	}

	public class_1799 getOutput(RebornRecipe recipe, int index) {
		if(index >= 0 && index < recipe.getOutputs().size()) {
			return recipe.getOutputs().get(index);
		}
		return class_1799.field_8037;
	}

	public class_2561 getTimeComponent(RebornRecipe recipe) {
		return new class_2588("techreborn.jei.recipe.processing.time.3", TIME_FORMAT.format(recipe.getTime() / 20D));
	}
}
