package thelm.techrebornjei.recipe.category;

import java.util.List;

import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_8786;
import reborncore.common.crafting.RebornRecipe;
import thelm.techrebornjei.gui.render.EnergyDisplayDrawable;

public abstract class AbstractRebornEnergyRecipeCategory<R extends RebornRecipe> extends AbstractRebornRecipeCategory<R> {

	public AbstractRebornEnergyRecipeCategory(RecipeType<class_8786<R>> recipeType) {
		super(recipeType);
	}

	public AbstractRebornEnergyRecipeCategory(RecipeType<class_8786<R>> recipeType, class_2561 title) {
		super(recipeType, title);
	}

	@Override
	public void draw(R recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
		EnergyDisplayDrawable.DOWN.draw(guiGraphics, 3, 3);
	}

	@Override
	public List<class_2561> getTooltipStrings(R recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
		if(EnergyDisplayDrawable.isMouseOver(3, 3, mouseX, mouseY)) {
			return List.of(
					class_2561.method_43471("techreborn.jei.recipe.energy"),
					class_2561.method_43469("techreborn.jei.recipe.running.cost", "E", recipe.getPower()).method_27692(class_124.field_1080),
					class_2561.method_43469("techreborn.jei.recipe.generator.total", recipe.getPower() * recipe.getTime()).method_27692(class_124.field_1080),
					class_2561.method_43470(jeiHelpers().getModIdHelper().getFormattedModNameForModId("techreborn")));
		}
		return List.of();
	}
}
