package thelm.techrebornjei.recipe.category;

import java.util.List;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_8786;
import reborncore.common.crafting.RebornRecipe;

public abstract class AbstractRebornRecipeCategory<R extends RebornRecipe> extends AbstractRecipeCategory<class_8786<R>> {

	public AbstractRebornRecipeCategory(RecipeType<class_8786<R>> recipeType, class_2561 title) {
		super(recipeType, title);
	}

	public AbstractRebornRecipeCategory(RecipeType<class_8786<R>> recipeType) {
		super(recipeType);
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_8786<R> recipeHolder, IFocusGroup focuses) {
		setRecipe(builder, recipeHolder.comp_1933(), focuses);
	}

	public abstract void setRecipe(IRecipeLayoutBuilder builder, R recipe, IFocusGroup focuses);

	@Override
	public void draw(class_8786<R> recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
		draw(recipe.comp_1933(), recipeSlotsView, guiGraphics, mouseX, mouseY);
	}

	public void draw(R recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {}

	@Override
	public List<class_2561> getTooltipStrings(class_8786<R> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
		return getTooltipStrings(recipeHolder.comp_1933(), recipeSlotsView, mouseX, mouseY);
	}

	public List<class_2561> getTooltipStrings(R recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
		return List.of();
	}

	public List<class_1799> getInput(RebornRecipe recipe, int index) {
		if(index >= 0 && index < recipe.getRebornIngredients().size()) {
			return recipe.getRebornIngredients().get(index).getPreviewStacks();
		}
		return List.of();
	}

	public class_1799 getOutput(RebornRecipe recipe, int index) {
		if(index >= 0 && index < recipe.getOutputs(registryAccess()).size()) {
			return recipe.getOutputs(registryAccess()).get(index);
		}
		return class_1799.field_8037;
	}

	public class_2561 getTimeComponent(RebornRecipe recipe) {
		return class_2561.method_43469("techreborn.jei.recipe.processing.time.3", TIME_FORMAT.format(recipe.getTime() / 20D));
	}
}
