package thelm.techrebornjei.recipe.category;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3611;
import net.minecraft.class_5455;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.common.fluid.container.FluidInstance;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.BlankDrawable;
import thelm.jeidrawables.gui.render.SpriteDrawable;
import thelm.techrebornjei.TechRebornJEI;

public abstract class AbstractRecipeCategory<R> implements IRecipeCategory<R> {

	public static final NumberFormat TIME_FORMAT = new DecimalFormat("###.##");

	public static final SpriteDrawable SLOT = new SpriteDrawable(() -> GuiBase.getSprite(GuiSprites.SLOT), 18, 18);
	public static final SpriteDrawable TANK_BACKGROUND = new SpriteDrawable(() -> GuiBase.getSprite(GuiSprites.TANK_BACKGROUND), 22, 56);
	public static final SpriteDrawable TANK_FOREGROUND = new SpriteDrawable(() -> GuiBase.getSprite(GuiSprites.TANK_FOREGROUND), 16, 50);

	public final RecipeType<R> recipeType;
	public final class_2561 title;
	public final IDrawable background;

	public AbstractRecipeCategory(RecipeType<R> recipeType, class_2561 title) {
		this.recipeType = recipeType;
		this.title = title;
		background = new BlankDrawable(getWidth(), getHeight());
	}

	public AbstractRecipeCategory(RecipeType<R> recipeType) {
		this.recipeType = recipeType;
		this.title = class_2561.method_43471(recipeType.getUid().toString());
		background = new BlankDrawable(getWidth(), getHeight());
	}

	@Override
	public RecipeType<R> getRecipeType() {
		return recipeType;
	}

	@Override
	public class_2561 getTitle() {
		return title;
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	@Override
	public int getWidth() {
		return 140;
	}

	@Override
	public int getHeight() {
		return 56;
	}

	@Override
	public IDrawable getIcon() {
		return null;
	}

	public class_5455 registryAccess() {
		return class_310.method_1551().field_1687.method_30349();
	}

	public class_327 font() {
		return class_310.method_1551().field_1772;
	}

	public IJeiHelpers jeiHelpers() {
		return TechRebornJEI.jeiHelpers;
	}

	public IPlatformFluidHelper<?> fluidHelper() {
		return jeiHelpers().getPlatformFluidHelper();
	}

	public IRecipeSlotBuilder addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, IDrawable background) {
		return builder.addSlot(ingredientRole, x, y).setBackground(background, 8 - background.getWidth() / 2, 8 - background.getHeight() / 2);
	}

	public IRecipeSlotBuilder addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, List<class_1799> itemStacks, IDrawable background) {
		return addItem(builder, ingredientRole, x, y, background).addItemStacks(itemStacks);
	}

	public IRecipeSlotBuilder addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, class_1799 itemStack, IDrawable background) {
		return addItem(builder, ingredientRole, x, y, background).addItemStack(itemStack);
	}

	public IRecipeSlotBuilder addFluid(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, FluidInstance fluidInstance) {
		class_3611 fluid = fluidInstance.getFluid();
		long amount = fluidInstance.getAmount().getRawValue() / (FluidConstants.BUCKET / fluidHelper().bucketVolume());
		long fraction = fluidInstance.getAmount().getRawValue() % (FluidConstants.BUCKET / 1000);
		class_2487 data = fluidInstance.getTag() == null ? null : fluidInstance.getTag().method_10553();
		IRecipeSlotBuilder slot = builder.addSlot(ingredientRole, x, y).setBackground(TANK_BACKGROUND, -3, -3).setOverlay(TANK_FOREGROUND, 0, 0).setFluidRenderer(Math.max(amount, 1), false, 16, 50).addTooltipCallback(JEIDrawables.appendFraction(fraction));
		if(!fluidInstance.isEmpty()) {
			slot.addFluidStack(fluid, amount, data);
		}
		return slot;
	}
}
