<img width="1539" height="365" alt="TN" src="https://github.com/user-attachments/assets/9fbd7894-9ad4-4282-87a2-f5517b6c1559" />

---

## 📖 Description

**Legacy Nether** is a mod/datapack that aims to faithfully recreate the **classic Nether from the Legacy Console Editions of Minecraft** (Xbox 360, PS3, Wii U, and others). This project is intended for nostalgic players who want to relive the atmosphere of the pre–1.16 Nether, or for those seeking a simpler, more dangerous, and barren Nether experience that focuses on survival and exploration rather than modern structures and biomes.

This mod removes all of the newer Nether content introduced in Minecraft Java Edition after 1.16, and restores the gameplay loop of the console versions:

* The Nether is composed only of **Nether Wastes**, with no Crimson or Warped Forests, Basalt Deltas, or Soul Sand Valleys.
* **Bastion Remnants are removed**, along with Piglins, Hoglins, Striders, Zoglins, and other modern mobs.
* The only mobs you’ll encounter are **Zombified Piglins, Ghasts, Magma Cubes, and Wither Skeletons** (which now spawn everywhere, not just in fortresses).
* **Blazes drop Glowstone Dust**, recreating the original console farming method.
* **Nether Wart patches** generate naturally on Soul Sand, just like in older editions. **(Thanks to @Soupio777)**
* **Ancient Debris and Netherite are absent**, restoring the classic Nether resource balance.


---

## ✨ Feature list

<details>
<summary>Feature List</summary>

## Key:
✅ - Implemented

☑️ - Planned

❌ - Not Implemented

|**Feature**|Implemented|Planned|
|-|-|-|
|Nether Wastes only (with soul sand & gravel patches)|✅|☑️|
|Bastion Remnants removed|✅|☑️|
|Classic mobs only (Zombified Piglins, Ghasts, Magma Cubes)|✅|☑️|
|Wither Skeletons spawn everywhere|✅|☑️|
|Nether Wart generates on Soul Sand (Thanks to @Soupio777)|✅|☑️|
|Blazes drop 0–2 Glowstone Dust|✅|☑️|
|No modern biomes (Crimson/Warped Forest, Soul Sand Valley, Basalt Deltas)|✅|☑️|
|Remove Ancient Debris / Netherite|✅|☑️|
|Disable newer advancements|✅|☑️|
|Remove other Nether structures (ruined portals, etc.)|✅|☑️|

</details>

---

## 🌌 Nostalgia

For the best nostalgic experience, Legacy Nether pairs well with resource packs and mods that restore classic visuals and mechanics, such as:

* [**Golden Days**](https://github.com/PoeticRainbow/golden-days/releases) by *PoeticRainbow* for authentic pre-1.14 textures.
* [**Nostalgic Tweaks**](https://modrinth.com/mod/nostalgic-tweaks) by *Adrenix* to bring back old fog, lighting, skies, and combat.
* [**Moderner Beta**](https://modrinth.com/mod/moderner-beta) for recreating Alpha/Beta terrain alongside the console-style Nether.

---

## ⚙️ Compatibility

* ✅ Works in **Minecraft 1.21.x**. No backports planned as of now.
* ❌ Not compatible with mods/datapacks that overhaul Nether biomes or structures.
* 🔧 Should be safe on servers as long as all players have the mod installed.

---

## 📦 Installation

1. Download the mod.
2. Place it in your `mods/` folder.
3. Launch Minecraft with your preferred loader.
4. Generate a new Nether (new chunks only!) to see the classic console Nether in action.

---

## 📸 Screenshots

<details>
<summary>Images</summary>

<img width="1920" height="1081" alt="2025-09-10_14 25 10" src="https://github.com/user-attachments/assets/67b38da1-bd4f-4990-8c5b-7ca2c262dd18" />
<img width="1920" height="1081" alt="2025-09-10_14 25 28" src="https://github.com/user-attachments/assets/0cfb724d-5998-4a02-8b1a-b2ec4a977791" />
<img width="1920" height="1081" alt="2025-09-10_14 25 59" src="https://github.com/user-attachments/assets/66f4e391-8051-4eda-a89e-9a30b39b2a5e" />
<img width="1920" height="1081" alt="2025-09-10_14 26 42" src="https://github.com/user-attachments/assets/cf738eb7-78fc-40d9-9bf1-9a66f3e24743" />
<img width="1920" height="1081" alt="2025-09-10_15 56 58" src="https://github.com/user-attachments/assets/32f3587e-fb37-41a5-8ea0-2ef72bcb0b3a" />

</details>

---

## 💡 Notes

* Existing Nether chunks will not retroactively change, **explore new chunks** or reset your Nether to experience the full effect.
* Blaze glowstone drops are balanced around the old console mechanics.

---

## 🤝 Support

* 💬 Join the community on [**Discord**](https://discord.com/invite/uhmuVmk2ut)
* 🛠️ Report issues or contribute on [**GitHub**](https://github.com/Pigzone00/Legacy-Nether)

---

## 🔄 Want Modern Features Too?

Prefer to keep Netherite, Bastions, and the new biomes? Check out the extended version:
[**Legacy Nether: Extended**](https://modrinth.com/datapack/legacy-nether-extended)
