/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.enums;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import lombok.Generated;

public enum DurabilityMode {
    ABORT(true, (breakCount, breakableCount) -> breakCount <= breakableCount ? -1 : breakCount, durability -> durability <= 1),
    SAVE(true, (breakCount, breakableCount) -> breakCount <= breakableCount ? breakCount - 1 : breakCount, durability -> durability <= 1),
    NORMAL(true, (breakCount, breakableCount) -> breakCount, durability -> false),
    BYPASS(false, (breakCount, breakableCount) -> breakableCount, durability -> false);

    private final boolean allowAbort;
    private final BiFunction<Integer, Integer, Integer> postProcessor;
    private final Predicate<Integer> shouldCancel;

    public int postProcess(int breakCount, int breakableCount) {
        return this.postProcessor.apply(breakCount, breakableCount);
    }

    public boolean shouldPreserve(int durability) {
        return this.shouldCancel.test(durability);
    }

    @Generated
    public boolean isAllowAbort() {
        return this.allowAbort;
    }

    @Generated
    public BiFunction<Integer, Integer, Integer> getPostProcessor() {
        return this.postProcessor;
    }

    @Generated
    public Predicate<Integer> getShouldCancel() {
        return this.shouldCancel;
    }

    @Generated
    private DurabilityMode(boolean allowAbort, BiFunction<Integer, Integer, Integer> postProcessor, Predicate<Integer> shouldCancel) {
        this.allowAbort = allowAbort;
        this.postProcessor = postProcessor;
        this.shouldCancel = shouldCancel;
    }
}

