/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.breaking;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.IBreakAttemptResult;
import fr.rakambda.fallingtree.common.tree.SuccessResult;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.tree.TreePart;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooSmallException;
import fr.rakambda.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.LeafForceBreaker;
import fr.rakambda.fallingtree.common.tree.breaking.LootHandler;
import fr.rakambda.fallingtree.common.tree.breaking.ToolDamageHandler;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;

public class InstantaneousTreeBreakingHandler
implements ITreeBreakingHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(InstantaneousTreeBreakingHandler.class);
    private static InstantaneousTreeBreakingHandler INSTANCE;
    private final FallingTreeCommon<?> mod;
    private final LeafForceBreaker leafForceBreaker;

    @Override
    public @NonNull IBreakAttemptResult breakTree(boolean isCancellable, @NonNull IPlayer player, @NonNull Tree tree) throws BreakTreeTooBigException, BreakTreeTooSmallException {
        IItemStack tool = player.getMainHandItem();
        ILevel level = tree.getLevel();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, this.mod.getConfiguration().getTools().getDamageMultiplicand(), this.mod.getConfiguration().getTools().getDurabilityMode(), tree.getBreakableCount(), this.mod.getConfiguration().getTrees().getMinSize(), this.mod.getConfiguration().getTrees().getMaxSize(), this.mod.getConfiguration().getTrees().getMaxSizeAction(), this.mod.getConfiguration().getTools().getDamageRounding());
        if (toolHandler.isPreserveTool()) {
            log.info("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.prevented_break_tool", new Object[0]));
            return SuccessResult.DO_NOT_CANCEL;
        }
        int wantToBreakCount = Math.min(tree.getBreakableCount(), toolHandler.getMaxBreakCount());
        LootHandler lootHandler = new LootHandler(wantToBreakCount, this.mod.getConfiguration().getTrees().getTrunkLootPercentage());
        int brokenCount = tree.getBreakableParts().stream().sorted(this.mod.getConfiguration().getTrees().getBreakOrder().getComparator()).limit(wantToBreakCount).map(TreePart::blockPos).mapToInt(logBlockPos -> {
            boolean isRemoved;
            IBlockState logState = level.getBlockState((IBlockPos)logBlockPos);
            if (!tree.getHitPos().equals(logBlockPos) && !this.mod.checkCanBreakBlock(level, (IBlockPos)logBlockPos, logState, player)) {
                return 0;
            }
            player.awardItemUsed(tool.getItem());
            if (!player.isCreative() || this.mod.getConfiguration().isLootInCreative()) {
                logState.getBlock().playerDestroy(level, player, this.mod.getConfiguration().getTrees().isSpawnItemsAtBreakPoint() ? tree.getHitPos() : logBlockPos, logState, level.getBlockEntity((IBlockPos)logBlockPos), tool, lootHandler.breakNewTrunk());
            }
            return (isRemoved = level.removeBlock((IBlockPos)logBlockPos, false)) ? 1 : 0;
        }).sum();
        int toolDamage = toolHandler.getActualDamage(brokenCount) - 1;
        if (toolDamage > 0) {
            tool.damage(toolDamage, player);
        }
        if (brokenCount >= wantToBreakCount) {
            this.leafForceBreaker.forceBreakDecayLeaves(player, tree, level);
        }
        if (player.isCreative() && this.mod.getConfiguration().isLootInCreative()) {
            tree.getStart().ifPresent(part -> part.blockState().getBlock().playerDestroy(level, player, tree.getHitPos(), part.blockState(), part.blockEntity(), tool, true));
        }
        return SuccessResult.DO_NOT_CANCEL;
    }

    public static @NonNull InstantaneousTreeBreakingHandler getInstance(@NonNull FallingTreeCommon<?> mod) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new InstantaneousTreeBreakingHandler(mod, new LeafForceBreaker(mod));
        }
        return INSTANCE;
    }

    @Generated
    public InstantaneousTreeBreakingHandler(FallingTreeCommon<?> mod, LeafForceBreaker leafForceBreaker) {
        this.mod = mod;
        this.leafForceBreaker = leafForceBreaker;
    }
}

