/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import shipwrights.dataplanets.DataplanetsMod;
import shipwrights.dataplanets.systemCreation.PlanetData;
import shipwrights.dataplanets.systemCreation.PlanetSource;
import shipwrights.dataplanets.util.Color;
import shipwrights.dataplanets.util.RegistryUtil;

@Mod.EventBusSubscriber
public class PlanetLookup {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<ResourceLocation, PlanetData> planets = new ConcurrentHashMap<ResourceLocation, PlanetData>();
    private static final String PATH = "planet_source";

    public static void store(MinecraftServer server, PlanetSource planet) {
        PlanetLookup.load(planet);
        RegistryUtil.writeToDatapack(server, PlanetLookup.id(planet.name()), PATH, PlanetSource.CODEC, planet);
    }

    private static void load(PlanetSource planet) {
        planets.put(PlanetLookup.id(planet.name()), PlanetData.fromPlanetSource(planet));
    }

    public static PlanetData get(ResourceLocation dimension) {
        return planets.getOrDefault(dimension, PlanetLookup.getDefault(dimension.m_135815_()));
    }

    private static ResourceLocation id(String dimensionName) {
        return ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)dimensionName);
    }

    private static PlanetData getDefault(String name) {
        return new PlanetData(name, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, ResourceLocation.withDefaultNamespace((String)"stone"), ResourceLocation.withDefaultNamespace((String)"water"), 1.0, new Color(128, 128, 128, 255));
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimpleJsonResourceReloadListener(GSON, PATH){

            protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
                for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                    try {
                        PlanetSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(error -> DataplanetsMod.LOGGER.error("Failed to parse planet source {}: {}", entry.getKey(), error)).ifPresent(PlanetLookup::load);
                    }
                    catch (Exception e) {
                        DataplanetsMod.LOGGER.error("Error loading planet source {}", (Object)entry.getKey(), (Object)e);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        planets.clear();
    }
}

