/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import shipwrights.dataplanets.compat.Compat;
import shipwrights.dataplanets.util.Color;
import shipwrights.dataplanets.util.RegistryUtil;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.data.SystemConfigModel;
import shipwrights.genesis.planets.PlanetData;

public class GenesisCompat
implements Compat {
    @Override
    public void addPlanetsToSpace(MinecraftServer server, List<shipwrights.dataplanets.systemCreation.PlanetData> planets) {
        ArrayList genesisPlanets = new ArrayList();
        for (shipwrights.dataplanets.systemCreation.PlanetData planetData : planets) {
            Color color = planetData.getPrimaryColour();
            Optional<PlanetData> genesisPlanetData = GenesisMod.registerPlanet(ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)planetData.name()), planetData.size(), planetData.gravity(), planetData.distanceFromStar(), planetData.orbitalPeriod(), (float)color.red() / 255.0f, (float)color.green() / 255.0f, (float)color.blue() / 255.0f);
            genesisPlanetData.ifPresent(genesisPlanets::add);
        }
        SystemConfigModel systemConfig = new SystemConfigModel(genesisPlanets.stream().map(PlanetData::toJsonModel).toList(), List.of());
        RegistryUtil.writeToDatapack(server, ResourceLocation.parse((String)"genesis:dataplanets"), "system_config", SystemConfigModel.CODEC, systemConfig);
    }

    @Override
    public ResourceLocation getSpaceDimensionEffects() {
        return ResourceLocation.parse((String)"genesis:great_unknown");
    }
}

