/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.factions;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import shipwrights.dataplanets.MutableTags;

public class Questable {
    public static final ResourceLocation QUESTING = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)"questing");

    public static String visitLocation(MinecraftServer server) {
        List levels = server.m_129784_().stream().toList();
        ResourceKey levelKey = (ResourceKey)levels.get(server.m_129783_().f_46441_.m_188503_(levels.size()));
        ServerLevel level = server.m_129880_(levelKey);
        BlockPos place = level.m_215011_(MutableTags.QUEST_STRUCTURES, BlockPos.f_121853_, 10000, true);
        return "visit " + levelKey.m_135782_() + " " + place.m_123341_() + " " + place.m_123342_() + " " + place.m_123343_();
    }

    public static String checkLocation(MinecraftServer server) {
        List levels = server.m_129784_().stream().toList();
        RandomSource rs = server.m_129783_().f_46441_;
        ResourceKey levelKey = (ResourceKey)levels.get(rs.m_188503_(levels.size()));
        BlockPos place = new BlockPos(rs.m_216339_(-10000, 10000), rs.m_216339_(-50, 200), rs.m_216339_(-10000, 10000));
        return "check " + levelKey.m_135782_() + " " + place.m_123341_() + " " + place.m_123342_() + " " + place.m_123343_();
    }

    public static String collectItems(MinecraftServer server) {
        Item f = BuiltInRegistries.f_257033_.m_123024_().filter(a -> new ItemStack((ItemLike)a).m_204117_(MutableTags.QUEST_ITEMS)).findAny().get();
        ItemStack stack = new ItemStack((ItemLike)f, server.m_129783_().f_46441_.m_216339_(1, 128));
        return "collect " + BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()) + " " + stack.m_41613_();
    }

    public static String randomQuest(MinecraftServer server) {
        return switch (server.m_129783_().f_46441_.m_188503_(3)) {
            case 0 -> Questable.visitLocation(server);
            case 1 -> Questable.collectItems(server);
            case 2 -> Questable.checkLocation(server);
            default -> "Unreachable, theoretically, but I had to make a default case";
        };
    }

    public static void randomQuestToPlayer(ServerPlayer spe) {
        CompoundTag quests = spe.f_8924_.m_129897_().m_78044_(QUESTING);
        CompoundTag player = quests.m_128469_(spe.m_20149_());
        String task = Questable.randomQuest(spe.f_8924_);
        String ret = Questable.randomQuest(spe.f_8924_);
        spe.m_213846_((Component)Component.m_237113_((String)("Task: " + task)));
        spe.m_213846_((Component)Component.m_237113_((String)("Return Task: " + ret)));
        player.m_128359_("task", task);
        player.m_128359_("return", ret);
        quests.m_128365_(spe.m_20149_(), (Tag)player);
        spe.f_8924_.m_129897_().m_78046_(QUESTING, quests);
    }

    public static void interpret(ServerPlayer spe) {
        String[] split;
        CompoundTag quests = spe.f_8924_.m_129897_().m_78044_(QUESTING);
        CompoundTag player = quests.m_128469_(spe.m_20149_());
        String string = player.m_128461_("task");
        if (player.m_128461_("task").contains("visit") || player.m_128461_("task").contains("check")) {
            split = string.split(" ");
            if (spe.m_284548_().m_46472_() == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)split[1]))) {
                BlockPos pos = new BlockPos(Integer.parseInt(split[2]), spe.m_146904_(), Integer.parseInt(split[4]));
                if (spe.m_20097_().m_123331_((Vec3i)pos) < 100.0) {
                    Questable.updateQuest(spe);
                }
            }
        }
        if (player.m_128461_("task").contains("collect")) {
            split = string.split(" ");
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.parse((String)split[1]));
            int count = Integer.parseInt(split[2]);
            if (spe.m_150109_().m_18947_(item) >= count) {
                Questable.updateQuest(spe);
            }
        }
    }

    public static void updateQuest(ServerPlayer spe) {
        CompoundTag quests = spe.f_8924_.m_129897_().m_78044_(QUESTING);
        CompoundTag player = quests.m_128469_(spe.m_20149_());
        if (!player.m_128461_("return").equals("finished")) {
            player.m_128359_("task", player.m_128461_("return"));
            player.m_128359_("return", "finished");
            spe.m_213846_((Component)Component.m_237113_((String)"Finished the task!"));
        } else {
            player.m_128359_("task", "not started");
            String[] v = player.m_128461_("reward").split(",");
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.parse((String)v[0]));
            spe.m_213846_((Component)Component.m_237113_((String)"Quest completed, reward added!"));
            spe.m_36356_(new ItemStack((ItemLike)item, Integer.parseInt(v[1])));
        }
        quests.m_128365_(spe.m_20149_(), (Tag)player);
        spe.f_8924_.m_129897_().m_78046_(QUESTING, quests);
    }
}

