/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;

public record PlanetSource(String name, double size, double distanceFromStar, double atmosphericDensity, double weirdness, double seaLevel, double terrainRoughness, double flavour) {
    public static final Codec<PlanetSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(PlanetSource::name), (App)Codec.DOUBLE.fieldOf("size").forGetter(PlanetSource::size), (App)Codec.DOUBLE.fieldOf("distanceFromStar").forGetter(PlanetSource::distanceFromStar), (App)Codec.DOUBLE.fieldOf("atmosphericDensity").forGetter(PlanetSource::atmosphericDensity), (App)Codec.DOUBLE.fieldOf("weirdness").forGetter(PlanetSource::weirdness), (App)Codec.DOUBLE.fieldOf("seaLevel").forGetter(PlanetSource::seaLevel), (App)Codec.DOUBLE.fieldOf("terrainRoughness").forGetter(PlanetSource::terrainRoughness), (App)Codec.DOUBLE.fieldOf("flavour").forGetter(PlanetSource::flavour)).apply((Applicative)instance, PlanetSource::new));

    public static PlanetSource createRandom(String name, RandomSource random) {
        return PlanetSource.builder(name).size(PlanetSource.doubleBetween(random, 0.5, 2.0)).distanceFromStar(PlanetSource.doubleBetween(random, 0.25, 2.0)).atmosphericDensity(PlanetSource.doubleBetween(random, 0.0, 2.0)).weirdness(PlanetSource.doubleBetween(random, 0.0, 2.0)).seaLevel(PlanetSource.doubleBetween(random, 0.0, 2.0)).terrainRoughness(PlanetSource.doubleBetween(random, 0.0, 2.0)).flavour(PlanetSource.doubleBetween(random, 0.0, 2.0)).build();
    }

    private static double doubleBetween(RandomSource random, double lower, double upper) {
        return (double)random.m_216339_((int)(lower * 100.0), (int)(upper * 100.0)) / 100.0;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private double size = 1.0;
        private double distanceFromStar = 1.0;
        private double atmosphericDensity = 1.0;
        private double weirdness = 1.0;
        private double seaLevel = 1.0;
        private double terrainRoughness = 1.0;
        private double flavour = 1.0;

        private Builder(String name) {
            this.name = name;
        }

        public Builder size(double size) {
            this.size = size;
            return this;
        }

        public Builder distanceFromStar(double distanceFromStar) {
            this.distanceFromStar = distanceFromStar;
            return this;
        }

        public Builder atmosphericDensity(double atmosphericDensity) {
            this.atmosphericDensity = atmosphericDensity;
            return this;
        }

        public Builder weirdness(double weirdness) {
            this.weirdness = weirdness;
            return this;
        }

        public Builder seaLevel(double seaLevel) {
            this.seaLevel = seaLevel;
            return this;
        }

        public Builder terrainRoughness(double terrainRoughness) {
            this.terrainRoughness = terrainRoughness;
            return this;
        }

        public Builder flavour(double flavour) {
            this.flavour = flavour;
            return this;
        }

        public PlanetSource build() {
            return new PlanetSource(this.name, this.size, this.distanceFromStar, this.atmosphericDensity, this.weirdness, this.seaLevel, this.terrainRoughness, this.flavour);
        }
    }
}

