/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import shipwrights.dataplanets.PlanetLookup;
import shipwrights.dataplanets.compat.Compat;
import shipwrights.dataplanets.systemCreation.PlanetData;
import shipwrights.dataplanets.systemCreation.PlanetSource;
import shipwrights.dataplanets.systemCreation.dimension.DimensionTypeCreator;
import shipwrights.dataplanets.systemCreation.dimension.biome.BiomeCreator;
import shipwrights.dataplanets.systemCreation.dimension.noise.TerrainGenCreator;
import shipwrights.dataplanets.systemCreation.naming.SystemNameGenerator;
import shipwrights.dataplanets.util.RegistryUtil;

public class SystemCreator {
    public void createSystem(MinecraftServer server, boolean scientificNamingStyle) {
        SystemCreationContext context = new SystemCreationContext(server, scientificNamingStyle);
        List<PlanetSource> sources = SystemCreator.createPlanetSources(context);
        ArrayList<PlanetData> planets = new ArrayList<PlanetData>();
        for (PlanetSource source : sources) {
            planets.add(this.createPlanet(source, context));
            PlanetLookup.store(server, source);
        }
        context.compat.addPlanetsToSpace(server, planets);
    }

    private static List<PlanetSource> createPlanetSources(SystemCreationContext context) {
        int planetCount = context.random.m_216339_(4, 9);
        ArrayList<PlanetSource> output = new ArrayList<PlanetSource>();
        for (int i = 0; i < planetCount; ++i) {
            output.add(PlanetSource.createRandom(context.nextPlanetName(), context.random));
        }
        return output;
    }

    public PlanetData createPlanet(PlanetSource source, SystemCreationContext context) {
        PlanetData planetData = PlanetData.fromPlanetSource(source);
        Holder<DimensionType> dimensionTypeHolder = DimensionTypeCreator.createAndRegisterDimensionType(context, planetData);
        List<Pair<Climate.ParameterPoint, Holder<Biome>>> biomeList = new BiomeCreator().createAndRegisterBiomes(context, planetData);
        Holder.Reference<NoiseGeneratorSettings> noiseSettings = TerrainGenCreator.createFromPlanetData(planetData, context);
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(biomeList));
        NoiseBasedChunkGenerator noiseBasedChunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)biomeSource, noiseSettings);
        LevelStem stem = new LevelStem(dimensionTypeHolder, (ChunkGenerator)noiseBasedChunkGenerator);
        RegistryUtil.registerLevelStem(context.server, ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)planetData.name()), stem);
        return planetData;
    }

    public static class SystemCreationContext {
        public final MinecraftServer server;
        public final RandomSource random = RandomSource.m_216327_();
        public final String systemName;
        public int currentPlanetIndex = 0;
        public Compat compat = Compat.get();

        public SystemCreationContext(MinecraftServer server, boolean scientificNameStyle) {
            this.server = server;
            this.systemName = SystemNameGenerator.get(scientificNameStyle).generate(this.random);
        }

        public String nextPlanetName() {
            return this.systemName + "abcdefghijklmnopqrstuvwxyz".charAt(this.currentPlanetIndex++);
        }
    }
}

