/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension;

import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.dimension.DimensionType;
import shipwrights.dataplanets.compat.Compat;
import shipwrights.dataplanets.systemCreation.PlanetData;
import shipwrights.dataplanets.systemCreation.SystemCreator;
import shipwrights.dataplanets.util.RegistryUtil;

public class DimensionTypeCreator {
    public static Holder<DimensionType> createAndRegisterDimensionType(SystemCreator.SystemCreationContext context, PlanetData planetData) {
        DimensionType dimensionType = DimensionTypeCreator.createFromPlanetData(planetData, context.compat);
        ResourceLocation dimensionTypeLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)(planetData.name() + "_dimension_type"));
        ResourceKey dimensionTypeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)dimensionTypeLocation);
        RegistryUtil.registerDimensionType(context.server, dimensionTypeLocation, dimensionType);
        return context.server.m_206579_().m_175515_(Registries.f_256787_).m_246971_(dimensionTypeKey);
    }

    private static DimensionType createFromPlanetData(PlanetData planetData, Compat compat) {
        boolean hasAtmosphere;
        boolean hasSkylight = planetData.distanceFromStar() < 3.0;
        boolean ultrawarm = planetData.temperature() > 1.8;
        boolean monsterSpawn = planetData.temperature() > 0.5 && planetData.temperature() < 2.0;
        boolean bl = hasAtmosphere = planetData.atmosphericDensity() > 0.3;
        if (hasAtmosphere) {
            return DimensionTypeCreator.createWithAtmosphere(hasSkylight, ultrawarm, false, monsterSpawn);
        }
        return DimensionTypeCreator.createAirless(hasSkylight, ultrawarm, monsterSpawn, compat);
    }

    public static DimensionType createWithAtmosphere(boolean hasSkylight, boolean ultrawarm, boolean hasCeiling, boolean monsterSpawn) {
        return new DimensionType(OptionalLong.empty(), hasSkylight, hasCeiling, ultrawarm, true, 1.0, true, false, -64, 384, 384, BlockTags.f_13058_, ResourceLocation.withDefaultNamespace((String)"overworld"), 0.0f, new DimensionType.MonsterSettings(monsterSpawn, false, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 0));
    }

    public static DimensionType createAirless(boolean hasSkylight, boolean ultrawarm, boolean monsterSpawn, Compat compat) {
        return new DimensionType(OptionalLong.empty(), hasSkylight, false, ultrawarm, true, 1.0, false, true, -64, 384, 384, BlockTags.f_13058_, compat.getSpaceDimensionEffects(), 0.0f, new DimensionType.MonsterSettings(monsterSpawn, false, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 0));
    }
}

