/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import shipwrights.dataplanets.systemCreation.PlanetData;
import shipwrights.dataplanets.systemCreation.SystemCreator;
import shipwrights.dataplanets.systemCreation.dimension.biome.BiomeFeatures;
import shipwrights.dataplanets.systemCreation.dimension.biome.BiomeTags;
import shipwrights.dataplanets.util.RegistryUtil;

public class BiomeCreator {
    public List<Pair<Climate.ParameterPoint, Holder<Biome>>> createAndRegisterBiomes(SystemCreator.SystemCreationContext context, PlanetData planetData) {
        int biomeCount = 3 + context.random.m_188503_(4);
        ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>> biomeList = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>();
        for (int i = 0; i < biomeCount; ++i) {
            double variationFactor = (double)i / (double)biomeCount;
            float biomeHeight = 0.0f;
            String biomeName = planetData.name() + "_biome_" + i;
            Biome biome = BiomeCreator.createBiome(context.random, planetData, variationFactor, context, biomeName);
            ResourceLocation biomeLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)biomeName);
            ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeLocation);
            RegistryUtil.registerBiome(context.server, biomeLocation, biome);
            BiomeTags.addTagsToBiome(context, biomeLocation, planetData, variationFactor);
            Climate.ParameterPoint climateParams = this.createClimateParameters(planetData, variationFactor, biomeHeight);
            Holder.Reference biomeHolder = context.server.m_206579_().m_175515_(Registries.f_256952_).m_246971_(biomeKey);
            biomeList.add((Pair<Climate.ParameterPoint, Holder<Biome>>)Pair.of((Object)climateParams, (Object)biomeHolder));
        }
        return biomeList;
    }

    private Climate.ParameterPoint createClimateParameters(PlanetData planetData, double variationFactor, float biomeHeight) {
        double tempMultiplier = BiomeCreator.clampClimateParameter(planetData.temperature());
        double humidityMultiplier = BiomeCreator.clampClimateParameter(planetData.atmosphericDensity());
        double erosionMultiplier = BiomeCreator.clampClimateParameter(planetData.weirdness() * 0.8);
        double ridgeMultiplier = BiomeCreator.clampClimateParameter(planetData.terrainRoughness() * 0.8);
        double continentalnessMultiplier = planetData.size() * 0.2;
        float sliceSize = 0.6f;
        float tempMin = (float)(tempMultiplier * -1.0 + variationFactor * 2.0 * tempMultiplier);
        float tempMax = tempMin + sliceSize;
        float humidityMin = (float)(humidityMultiplier * -1.0 + variationFactor * 2.0 * humidityMultiplier);
        float humidityMax = humidityMin + sliceSize;
        float continentalnessMin = (float)(continentalnessMultiplier * -1.0 + variationFactor * 2.0 * continentalnessMultiplier);
        float continentalnessMax = continentalnessMin + sliceSize;
        float erosionMin = (float)(erosionMultiplier * -1.0 + variationFactor * 2.0 * erosionMultiplier);
        float erosionMax = erosionMin + sliceSize;
        float depth = biomeHeight;
        float weirdnessMin = (float)(ridgeMultiplier * -1.0 + variationFactor * 2.0 * ridgeMultiplier);
        float weirdnessMax = weirdnessMin + sliceSize;
        return Climate.m_186798_((Climate.Parameter)Climate.Parameter.m_186822_((float)BiomeCreator.clampClimate(tempMin), (float)BiomeCreator.clampClimate(tempMax)), (Climate.Parameter)Climate.Parameter.m_186822_((float)BiomeCreator.clampClimate(humidityMin), (float)BiomeCreator.clampClimate(humidityMax)), (Climate.Parameter)Climate.Parameter.m_186822_((float)BiomeCreator.clampClimate(continentalnessMin), (float)BiomeCreator.clampClimate(continentalnessMax)), (Climate.Parameter)Climate.Parameter.m_186822_((float)BiomeCreator.clampClimate(erosionMin), (float)BiomeCreator.clampClimate(erosionMax)), (Climate.Parameter)Climate.Parameter.m_186820_((float)depth), (Climate.Parameter)Climate.Parameter.m_186822_((float)BiomeCreator.clampClimate(weirdnessMin), (float)BiomeCreator.clampClimate(weirdnessMax)), (float)0.0f);
    }

    private static double clampClimateParameter(double value) {
        return Math.max(-1.99, Math.min(1.99, value));
    }

    private static float clampClimate(double value) {
        return (float)Math.max(-2.0, Math.min(2.0, value));
    }

    private static Biome createBiome(RandomSource random, PlanetData planetData, double variationFactor, SystemCreator.SystemCreationContext context, String biomeName) {
        float temperature = (float)(planetData.temperature() + (variationFactor - 0.5) * 0.4);
        float downfall = (float)((planetData.atmosphericDensity() + planetData.seaLevel()) / 2.0);
        boolean hasPrecipitation = (double)downfall > 0.3 && (double)temperature > 0.15;
        BiomeSpecialEffects.Builder effectsBuilder = new BiomeSpecialEffects.Builder().m_48019_(BiomeCreator.deriveFogColor(planetData, variationFactor)).m_48034_(BiomeCreator.deriveWaterColor(planetData, variationFactor)).m_48037_(BiomeCreator.deriveWaterFogColor(planetData, variationFactor)).m_48040_(BiomeCreator.deriveSkyColor(planetData, variationFactor)).m_48045_(BiomeCreator.deriveGrassColor(planetData, variationFactor)).m_48043_(BiomeCreator.deriveFoliageColor(planetData, variationFactor));
        MobSpawnSettings mobSpawnSettings = new MobSpawnSettings.Builder().m_48381_();
        BiomeGenerationSettings generationSettings = BiomeFeatures.getBiomeGenerationSettings(context, planetData, variationFactor, biomeName);
        return new Biome.BiomeBuilder().m_264558_(hasPrecipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(effectsBuilder.m_48018_()).m_47605_(mobSpawnSettings).m_47601_(generationSettings).m_47592_();
    }

    private static int deriveFogColor(PlanetData planetData, double variationFactor) {
        int blue;
        int green;
        int red;
        double temp = planetData.temperature();
        double atmosphere = planetData.atmosphericDensity();
        double biomeTemp = temp + (variationFactor - 0.5) * 0.3;
        int alpha = Math.min(255, (int)(atmosphere * 127.5) + 64);
        if (biomeTemp > 1.5) {
            red = 255;
            green = 200 - (int)((biomeTemp - 1.5) * 100.0) + (int)(variationFactor * 30.0);
            blue = 100 - (int)((biomeTemp - 1.5) * 50.0) + (int)(variationFactor * 20.0);
        } else if (biomeTemp < 0.5) {
            red = 150 + (int)((0.5 - biomeTemp) * 200.0) - (int)(variationFactor * 40.0);
            green = 180 + (int)((0.5 - biomeTemp) * 150.0) - (int)(variationFactor * 30.0);
            blue = 255;
        } else {
            red = 192 + (int)(variationFactor * 20.0) - 10;
            green = 216 + (int)(variationFactor * 15.0) - 7;
            blue = 255;
        }
        red = Math.max(0, Math.min(255, red));
        green = Math.max(0, Math.min(255, green));
        blue = Math.max(0, Math.min(255, blue));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private static int deriveWaterColor(PlanetData planetData, double variationFactor) {
        if (planetData.temperature() > 1.8) {
            return 0xFF6600 + (int)(variationFactor * 17408.0);
        }
        if (planetData.temperature() < 0.4) {
            return 0xAADDFF - (int)(variationFactor * 8704.0);
        }
        return 4159204 + (int)(variationFactor * 2113568.0);
    }

    private static int deriveWaterFogColor(PlanetData planetData, double variationFactor) {
        int waterColor = BiomeCreator.deriveWaterColor(planetData, variationFactor);
        return (waterColor & 0xFEFEFE) >> 1;
    }

    private static int deriveSkyColor(PlanetData planetData, double variationFactor) {
        double temp = planetData.temperature();
        double atmosphere = planetData.atmosphericDensity();
        if (atmosphere < 0.3) {
            return (int)(variationFactor * 1052688.0);
        }
        if (temp > 2.0) {
            return 0x8B0000 + (int)(variationFactor * 3145728.0);
        }
        if (temp > 1.5) {
            return 16747520 - (int)(variationFactor * 8192.0);
        }
        if (temp < 0.5) {
            return 12638463 - (int)(variationFactor * 4128.0);
        }
        return 7907327 + (int)(variationFactor * 263168.0);
    }

    private static int deriveGrassColor(PlanetData planetData, double variationFactor) {
        double temp = planetData.temperature();
        double weirdness = planetData.weirdness();
        if (weirdness > 1.5) {
            return 0xAA55AA + (int)(variationFactor * 13056.0);
        }
        if (temp > 1.5) {
            return 12564309 - (int)(variationFactor * 2105344.0);
        }
        if (temp < 0.5) {
            return 0x5599AA + (int)(variationFactor * 8704.0);
        }
        return 7842607 + (int)(variationFactor * 1056784.0);
    }

    private static int deriveFoliageColor(PlanetData planetData, double variationFactor) {
        int grassColor = BiomeCreator.deriveGrassColor(planetData, variationFactor);
        return (grassColor & 0xFEFEFE) - 0x101010;
    }
}

