/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension.biome;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.jetbrains.annotations.NotNull;
import shipwrights.dataplanets.systemCreation.PlanetData;
import shipwrights.dataplanets.systemCreation.SystemCreator;
import shipwrights.dataplanets.util.RegistryUtil;

public class BiomeFeatures {
    @NotNull
    public static BiomeGenerationSettings getBiomeGenerationSettings(SystemCreator.SystemCreationContext context, PlanetData planetData, double variationFactor, String biomeName) {
        BiomeGenerationSettings.PlainBuilder builder = new BiomeGenerationSettings.PlainBuilder();
        RandomSource random = RandomSource.m_216335_((long)biomeName.hashCode());
        BiomeFeatures.addCarvers(context, builder);
        if ((planetData.atmosphericDensity() > 0.8 || planetData.weirdness() > 0.8) && planetData.flavour() > 0.3) {
            BiomeFeatures.addDripstone(context, builder);
        }
        if (planetData.atmosphericDensity() > 0.3 && random.m_188500_() > 0.7) {
            BiomeFeatures.addDeltas(context, builder, biomeName, planetData);
        }
        if (planetData.atmosphericDensity() > 0.7) {
            BiomeFeatures.addLakes(context, builder, biomeName, planetData);
        }
        if (planetData.temperature() < 0.5 && random.m_188500_() > 0.7) {
            BiomeFeatures.addIceSpikes(context, builder);
        } else if (planetData.gravity() < 1.0 && random.m_188500_() > 0.8) {
            BiomeFeatures.addCrystals(context, builder, biomeName, planetData);
        }
        return builder.m_255380_();
    }

    private static void addCrystals(SystemCreator.SystemCreationContext context, BiomeGenerationSettings.PlainBuilder builder, String biomeName, PlanetData planetData) {
        ArrayList<PlacementModifier> modifiers = new ArrayList<PlacementModifier>();
        modifiers.add((PlacementModifier)CountOnEveryLayerPlacement.m_191604_((int)40));
        BiomeFeatures.addSimpleFeature(context, builder, biomeName + "_crystal", "crystal", modifiers, 0);
    }

    private static void addSimpleFeature(SystemCreator.SystemCreationContext context, BiomeGenerationSettings.PlainBuilder builder, String placedFeatureName, String featureName, List<PlacementModifier> modifiers, int decorationStep) {
        Registry configuredFeatureRegistry = context.server.m_206579_().m_175515_(Registries.f_256911_);
        Registry placedFeatureRegistry = context.server.m_206579_().m_175515_(Registries.f_256988_);
        Registry featureRegistry = context.server.m_206579_().m_175515_(Registries.f_256833_);
        ResourceLocation placedResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)placedFeatureName);
        ResourceLocation featureResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)featureName);
        ResourceKey configuredKey = ResourceKey.m_135785_((ResourceKey)configuredFeatureRegistry.m_123023_(), (ResourceLocation)placedResourceLocation);
        ResourceKey placedKey = ResourceKey.m_135785_((ResourceKey)placedFeatureRegistry.m_123023_(), (ResourceLocation)placedResourceLocation);
        Holder.Reference feature = featureRegistry.m_246971_(ResourceKey.m_135785_((ResourceKey)featureRegistry.m_123023_(), (ResourceLocation)featureResourceLocation));
        ConfiguredFeature configuredFeature = new ConfiguredFeature((Feature)feature.m_203334_(), (FeatureConfiguration)FeatureConfiguration.f_67737_);
        RegistryUtil.registerConfiguredFeature(context.server, placedResourceLocation, configuredFeature);
        PlacedFeature placedFeature = new PlacedFeature((Holder)configuredFeatureRegistry.m_246971_(configuredKey), modifiers);
        RegistryUtil.registerPlacedFeature(context.server, placedResourceLocation, placedFeature);
        Optional placedHolder = placedFeatureRegistry.m_203636_(placedKey);
        placedHolder.ifPresent(ref -> builder.m_254982_(decorationStep, (Holder)ref));
    }

    private static void addIceSpikes(SystemCreator.SystemCreationContext context, BiomeGenerationSettings.PlainBuilder builder) {
        Registry placedFeatures = context.server.m_206579_().m_175515_(Registries.f_256988_);
        Optional iceSpikes = placedFeatures.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)ResourceLocation.parse((String)"ice_spike")));
        iceSpikes.ifPresent(ref -> builder.m_254982_(0, (Holder)ref));
    }

    private static void addDripstone(SystemCreator.SystemCreationContext context, BiomeGenerationSettings.PlainBuilder builder) {
        Registry placedFeatures = context.server.m_206579_().m_175515_(Registries.f_256988_);
        Optional dripstone = placedFeatures.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)ResourceLocation.parse((String)"large_dripstone")));
        Optional dripstone_cluster = placedFeatures.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)ResourceLocation.parse((String)"dripstone_cluster")));
        Optional pointed_dripstone = placedFeatures.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)ResourceLocation.parse((String)"pointed_dripstone")));
        dripstone.ifPresent(ref -> builder.m_254982_(0, (Holder)ref));
        dripstone_cluster.ifPresent(ref -> builder.m_254982_(0, (Holder)ref));
        pointed_dripstone.ifPresent(ref -> builder.m_254982_(0, (Holder)ref));
    }

    private static void addCarvers(SystemCreator.SystemCreationContext context, BiomeGenerationSettings.PlainBuilder builder) {
        Registry carvers = context.server.m_206579_().m_175515_(Registries.f_257003_);
        Holder.Reference canyon = carvers.m_246971_(Carvers.f_126849_);
        Holder.Reference cave = carvers.m_246971_(Carvers.f_126848_);
        Holder.Reference cave_extra = carvers.m_246971_(Carvers.f_194741_);
        builder.m_254863_(GenerationStep.Carving.AIR, (Holder)canyon).m_254863_(GenerationStep.Carving.AIR, (Holder)cave).m_254863_(GenerationStep.Carving.AIR, (Holder)cave_extra);
    }

    private static void addDeltas(SystemCreator.SystemCreationContext context, BiomeGenerationSettings.PlainBuilder builder, String biomeName, PlanetData planetData) {
        Registry configuredFeatureRegistry = context.server.m_206579_().m_175515_(Registries.f_256911_);
        Registry placedFeatureRegistry = context.server.m_206579_().m_175515_(Registries.f_256988_);
        ResourceLocation configuredResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)(biomeName + "_delta"));
        ResourceLocation placedResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)(biomeName + "_delta"));
        ResourceKey configuredKey = ResourceKey.m_135785_((ResourceKey)configuredFeatureRegistry.m_123023_(), (ResourceLocation)configuredResourceLocation);
        ResourceKey placedKey = ResourceKey.m_135785_((ResourceKey)placedFeatureRegistry.m_123023_(), (ResourceLocation)placedResourceLocation);
        ConfiguredFeature<?, ?> feature = BiomeFeatures.getConfiguredDelta(context.server, planetData);
        RegistryUtil.registerConfiguredFeature(context.server, configuredResourceLocation, feature);
        ArrayList<CountOnEveryLayerPlacement> modifiers = new ArrayList<CountOnEveryLayerPlacement>();
        modifiers.add(CountOnEveryLayerPlacement.m_191604_((int)40));
        PlacedFeature placedFeature = new PlacedFeature((Holder)configuredFeatureRegistry.m_246971_(configuredKey), modifiers);
        RegistryUtil.registerPlacedFeature(context.server, placedResourceLocation, placedFeature);
        Optional placedHolder = placedFeatureRegistry.m_203636_(placedKey);
        placedHolder.ifPresent(ref -> builder.m_254982_(0, (Holder)ref));
    }

    @NotNull
    private static ConfiguredFeature<?, ?> getConfiguredDelta(MinecraftServer server, PlanetData planetData) {
        Block primaryFluid = (Block)server.m_206579_().m_175515_(Registries.f_256747_).m_7745_(planetData.primaryFluid());
        BlockState primaryFluidState = Objects.requireNonNullElse(primaryFluid, Blocks.f_49991_).m_49966_();
        BlockState solidState = primaryFluidState == Blocks.f_49991_.m_49966_() ? Blocks.f_50450_.m_49966_() : Blocks.f_220864_.m_49966_();
        DeltaFeatureConfiguration configuration = new DeltaFeatureConfiguration(primaryFluidState, solidState, (IntProvider)UniformInt.m_146622_((int)3, (int)7), (IntProvider)UniformInt.m_146622_((int)0, (int)2));
        return new ConfiguredFeature(Feature.f_65748_, (FeatureConfiguration)configuration);
    }

    private static void addLakes(SystemCreator.SystemCreationContext context, BiomeGenerationSettings.PlainBuilder builder, String biomeName, PlanetData planetData) {
        Registry configuredFeatureRegistry = context.server.m_206579_().m_175515_(Registries.f_256911_);
        Registry placedFeatureRegistry = context.server.m_206579_().m_175515_(Registries.f_256988_);
        ResourceLocation configuredResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)(biomeName + "_lake"));
        ResourceLocation placedResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)(biomeName + "_lake"));
        ResourceKey configuredKey = ResourceKey.m_135785_((ResourceKey)configuredFeatureRegistry.m_123023_(), (ResourceLocation)configuredResourceLocation);
        ResourceKey placedKey = ResourceKey.m_135785_((ResourceKey)placedFeatureRegistry.m_123023_(), (ResourceLocation)placedResourceLocation);
        ConfiguredFeature<?, ?> feature = BiomeFeatures.getConfiguredLake(context.server, planetData);
        RegistryUtil.registerConfiguredFeature(context.server, configuredResourceLocation, feature);
        ArrayList<CountOnEveryLayerPlacement> modifiers = new ArrayList<CountOnEveryLayerPlacement>();
        modifiers.add(CountOnEveryLayerPlacement.m_191604_((int)1));
        PlacedFeature placedFeature = new PlacedFeature((Holder)configuredFeatureRegistry.m_246971_(configuredKey), modifiers);
        RegistryUtil.registerPlacedFeature(context.server, placedResourceLocation, placedFeature);
        Optional placedHolder = placedFeatureRegistry.m_203636_(placedKey);
        placedHolder.ifPresent(ref -> builder.m_254982_(0, (Holder)ref));
    }

    @NotNull
    private static ConfiguredFeature<?, ?> getConfiguredLake(MinecraftServer server, PlanetData planetData) {
        Block primaryFluid = (Block)server.m_206579_().m_175515_(Registries.f_256747_).m_7745_(planetData.primaryFluid());
        BlockState primaryFluidState = Objects.requireNonNullElse(primaryFluid, Blocks.f_49991_).m_49966_();
        BlockState solidState = primaryFluidState == Blocks.f_49991_.m_49966_() ? Blocks.f_50450_.m_49966_() : ((Block)BuiltInRegistries.f_256975_.m_7745_(planetData.primaryBlock())).m_49966_();
        LakeFeature.Configuration configuration = new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)primaryFluidState), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)solidState));
        return new ConfiguredFeature(Feature.f_65783_, (FeatureConfiguration)configuration);
    }
}

