/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension.biome.features;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.Tags;

public class CrystalFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Set<Block> stainedGlass = new HashSet<Block>();
    private static List<Block> stainedGlassList;

    public CrystalFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> arg) {
        BlockPos blockPos = arg.m_159777_();
        RandomSource randomSource = arg.m_225041_();
        WorldGenLevel worldGenLevel = arg.m_159774_();
        while (worldGenLevel.m_46859_(blockPos) && blockPos.m_123342_() > worldGenLevel.m_141937_() + 2) {
            blockPos = blockPos.m_7495_();
        }
        BlockState startState = worldGenLevel.m_8055_(blockPos);
        if (stainedGlass.isEmpty()) {
            BuiltInRegistries.f_256975_.m_206058_(Tags.Blocks.STAINED_GLASS).iterator().forEachRemaining(blockHolder -> stainedGlass.add((Block)blockHolder.get()));
            stainedGlassList = stainedGlass.stream().toList();
        }
        Block block = stainedGlassList.get(randomSource.m_188503_(stainedGlassList.size()));
        if (!startState.m_280296_() || stainedGlass.contains(startState.m_60734_()) || randomSource.m_188503_(120) != 0) {
            return false;
        }
        blockPos = blockPos.m_6625_(5 + randomSource.m_188503_(12));
        int height = 20 + randomSource.m_188503_(15);
        int maxRadius = 4 + randomSource.m_188503_(3);
        int baseRadius = 2 + randomSource.m_188503_(2);
        int expandHeight = (int)((float)height * 0.5f);
        int taperStartHeight = (int)((float)height * 0.6f);
        for (int k = 0; k < height; ++k) {
            int radius;
            if (k < expandHeight) {
                float expandProgress = (float)k / (float)expandHeight;
                radius = (int)((float)baseRadius + (float)(maxRadius - baseRadius) * expandProgress);
            } else if (k < taperStartHeight) {
                radius = maxRadius;
            } else {
                float taperProgress = (float)(k - taperStartHeight) / (float)(height - taperStartHeight);
                radius = Math.max(0, (int)((float)maxRadius * (1.0f - taperProgress)));
            }
            for (int m = -radius; m <= radius; ++m) {
                for (int n = -radius; n <= radius; ++n) {
                    if (Math.abs(m) + Math.abs(n) > radius) continue;
                    this.m_5974_((LevelWriter)worldGenLevel, blockPos.m_7918_(m, k, n), block.m_49966_());
                }
            }
        }
        for (int o = -1; o <= 1; ++o) {
            for (int p = -1; p <= 1; ++p) {
                if (Math.abs(o) + Math.abs(p) > 1) continue;
                BlockPos blockPos2 = blockPos.m_7918_(o, -1, p);
                int depth = 3 + randomSource.m_188503_(3);
                for (int d = 0; d < depth; ++d) {
                    this.m_5974_((LevelWriter)worldGenLevel, blockPos2, block.m_49966_());
                    blockPos2 = blockPos2.m_7495_();
                }
            }
        }
        return true;
    }
}

