/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import shipwrights.dataplanets.util.Color;

public record BlockInfo(double mass, double temperature, double humidity, double minerality, double weirdness, ResourceLocation block, String color) {
    public static final Codec<BlockInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("mass").forGetter(BlockInfo::mass), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(BlockInfo::temperature), (App)Codec.DOUBLE.fieldOf("humidity").forGetter(BlockInfo::humidity), (App)Codec.DOUBLE.fieldOf("minerality").forGetter(BlockInfo::minerality), (App)Codec.DOUBLE.fieldOf("weirdness").forGetter(BlockInfo::weirdness), (App)ResourceLocation.f_135803_.fieldOf("block").forGetter(BlockInfo::block), (App)Codec.STRING.fieldOf("color").forGetter(BlockInfo::color)).apply((Applicative)instance, BlockInfo::new));

    public Color getColor() {
        String hex = this.color.startsWith("#") ? this.color.substring(1) : this.color;
        int rgb = Integer.parseInt(hex, 16);
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return new Color(red, green, blue, 255);
    }
}

