/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension.blocks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shipwrights.dataplanets.systemCreation.dimension.blocks.BlockInfo;

@Mod.EventBusSubscriber
public class BlockPalettes {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockPalettes.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Set<BlockInfo> SOLIDS = new HashSet<BlockInfo>();
    public static Set<BlockInfo> FLUIDS = new HashSet<BlockInfo>();

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimpleJsonResourceReloadListener(GSON, "block_palettes/solids"){

            protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                SOLIDS.clear();
                for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                    try {
                        BlockPalette palette = BlockPalette.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(error -> LOGGER.error("Failed to parse block palette {}: {}", entry.getKey(), error)).orElse(null);
                        if (palette == null) continue;
                        if (palette.replace().booleanValue()) {
                            SOLIDS.clear();
                        }
                        SOLIDS.addAll(palette.values());
                        LOGGER.info("Loaded {} solid block entries from {}", (Object)palette.values().size(), (Object)entry.getKey());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error loading solid block palette {}", (Object)entry.getKey(), (Object)e);
                    }
                }
                LOGGER.info("Total solid blocks loaded: {}", (Object)SOLIDS.size());
            }
        });
        event.addListener((PreparableReloadListener)new SimpleJsonResourceReloadListener(GSON, "block_palettes/fluids"){

            protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                FLUIDS.clear();
                for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                    try {
                        BlockPalette palette = BlockPalette.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(error -> LOGGER.error("Failed to parse block palette {}: {}", entry.getKey(), error)).orElse(null);
                        if (palette == null) continue;
                        if (palette.replace().booleanValue()) {
                            FLUIDS.clear();
                        }
                        FLUIDS.addAll(palette.values());
                        LOGGER.info("Loaded {} fluid block entries from {}", (Object)palette.values().size(), (Object)entry.getKey());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error loading fluid block palette {}", (Object)entry.getKey(), (Object)e);
                    }
                }
                LOGGER.info("Total fluid blocks loaded: {}", (Object)FLUIDS.size());
            }
        });
    }

    record BlockPalette(List<BlockInfo> values, Boolean replace) {
        public static final Codec<BlockPalette> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockInfo.CODEC.listOf().fieldOf("values").forGetter(BlockPalette::values), (App)Codec.BOOL.fieldOf("replace").forGetter(BlockPalette::replace)).apply((Applicative)instance, BlockPalette::new));
    }
}

