/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension.noise;

import com.mojang.serialization.MapCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public class AlienDensityFunction
implements DensityFunction.SimpleFunction {
    private final long seed;
    private final double worldScale;
    private static final AlienDensityFunction INSTANCE = new AlienDensityFunction();
    public static final MapCodec<AlienDensityFunction> MAP_CODEC = MapCodec.unit((Object)INSTANCE);
    public static final KeyDispatchDataCodec<AlienDensityFunction> CODEC = KeyDispatchDataCodec.m_216238_(MAP_CODEC);

    public static ResourceLocation getResourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)"alien");
    }

    public AlienDensityFunction(long seed, double worldScale) {
        this.seed = seed;
        this.worldScale = worldScale;
    }

    public AlienDensityFunction() {
        this(8675309L, 512.0);
    }

    public double m_207386_(DensityFunction.FunctionContext ctx) {
        double terrain;
        double x = (double)ctx.m_207115_() / this.worldScale;
        double z = (double)ctx.m_207113_() / this.worldScale;
        double y = 0.0;
        double density = 0.0;
        double warpX = this.fbmNoise(x * 0.5 + 31.5, 0.0, z * 0.5 + 123.4, 3, 0.5) * 0.4;
        double warpZ = this.fbmNoise(x * 0.5 + 210.0, 0.0, z * 0.5 + 11.0, 3, 0.5) * 0.4;
        double wx = x + warpX;
        double wz = z + warpZ;
        double biomeNoise = this.fbmNoise(x * 0.3, 0.0, z * 0.3, 2, 0.5);
        double mountains = this.fbmNoise(wx * 1.0, 0.0, wz * 1.0, 4, 0.6);
        mountains = Math.pow(Math.max(0.0, mountains * 0.5 + 0.5), 1.5) * 1.2;
        double hills = this.fbmNoise(wx * 2.0, y * 0.5, wz * 2.0, 4, 0.55) * 0.4;
        double ridges = this.ridgedNoise(wx * 1.5, y * 2.0, wz * 1.5, 4);
        ridges = Math.pow(ridges, 1.5) * 0.8;
        double plateauBase = this.fbmNoise(wx * 0.8, 0.0, wz * 0.8, 3, 0.5);
        double plateauHeight = Math.floor(plateauBase * 5.0) / 5.0;
        double plateaus = plateauHeight * 0.6;
        double terraceNoise = this.fbmNoise(wx * 1.2, 0.0, wz * 1.2, 2, 0.5);
        double terraces = Math.sin((y + terraceNoise * 0.3) * Math.PI * 6.0) * 0.08;
        if (biomeNoise < -0.3) {
            terrain = mountains * 0.8 + hills;
        } else if (biomeNoise > 0.3) {
            terrain = plateaus + ridges * 0.3 + terraces;
        } else {
            double blend = (biomeNoise + 0.3) / 0.6;
            double hillTerrain = mountains * 0.8 + hills;
            double ridgeTerrain = plateaus + ridges * 0.5 + terraces;
            terrain = AlienDensityFunction.lerp(hillTerrain, ridgeTerrain, blend);
        }
        density += terrain;
        double detail1 = this.fbmNoise(wx * 4.0, y * 2.0, wz * 4.0, 3, 0.5) * 0.15;
        double detail2 = this.fbmNoise(wx * 8.0, y * 4.0, wz * 8.0, 2, 0.45) * 0.08;
        density += detail1 + detail2;
        double cave = this.fbmNoise(wx * 6.0, y * 4.0, wz * 6.0, 3, 0.6);
        cave = Math.abs(cave);
        if (cave < 0.2) {
            density -= (0.2 - cave) * 4.0;
        }
        if (y < -1.5) {
            double floorBoost = (-1.5 - y) * 4.0;
            density += floorBoost;
        }
        if (y > 1.0) {
            density -= (y - 1.0) * 3.0;
        }
        return AlienDensityFunction.clamp(density, -4.0, 4.0);
    }

    public void m_207362_(double[] ds, DensityFunction.ContextProvider provider) {
        for (int i = 0; i < ds.length; ++i) {
            ds[i] = this.m_207386_(provider.m_207263_(i));
        }
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)this);
    }

    public double m_207402_() {
        return -4.0;
    }

    public double m_207401_() {
        return 4.0;
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    private double noise(double x, double y, double z) {
        int xi = (int)Math.floor(x);
        int yi = (int)Math.floor(y);
        int zi = (int)Math.floor(z);
        double xf = x - (double)xi;
        double yf = y - (double)yi;
        double zf = z - (double)zi;
        double u = this.fade(xf);
        double v = this.fade(yf);
        double w = this.fade(zf);
        double c000 = this.hash(xi, yi, zi);
        double c100 = this.hash(xi + 1, yi, zi);
        double c010 = this.hash(xi, yi + 1, zi);
        double c110 = this.hash(xi + 1, yi + 1, zi);
        double c001 = this.hash(xi, yi, zi + 1);
        double c101 = this.hash(xi + 1, yi, zi + 1);
        double c011 = this.hash(xi, yi + 1, zi + 1);
        double c111 = this.hash(xi + 1, yi + 1, zi + 1);
        double x00 = AlienDensityFunction.lerp(c000, c100, u);
        double x10 = AlienDensityFunction.lerp(c010, c110, u);
        double x01 = AlienDensityFunction.lerp(c001, c101, u);
        double x11 = AlienDensityFunction.lerp(c011, c111, u);
        double y0 = AlienDensityFunction.lerp(x00, x10, v);
        double y1 = AlienDensityFunction.lerp(x01, x11, v);
        return AlienDensityFunction.lerp(y0, y1, w);
    }

    private double hash(int x, int y, int z) {
        long n = (long)x * 1619L + (long)y * 31337L + (long)z * 6971L + this.seed;
        n = n << 13 ^ n;
        return (double)(n * (n * n * 60493L + 19990303L) + 1376312589L & Integer.MAX_VALUE) / 1.073741824E9 - 1.0;
    }

    private double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private double fbmNoise(double x, double y, double z, int octaves, double persistence) {
        double total = 0.0;
        double amplitude = 1.0;
        double frequency = 1.0;
        double max = 0.0;
        for (int i = 0; i < octaves; ++i) {
            total += this.noise(x * frequency, y * frequency, z * frequency) * amplitude;
            max += amplitude;
            amplitude *= persistence;
            frequency *= 2.01;
        }
        return total / max;
    }

    private double ridgedNoise(double x, double y, double z, int octaves) {
        double total = 0.0;
        double amplitude = 1.0;
        double frequency = 1.0;
        double prev = 1.0;
        for (int i = 0; i < octaves; ++i) {
            double n = 1.0 - Math.abs(this.noise(x * frequency, y * frequency, z * frequency));
            n *= n;
            total += n * amplitude * prev;
            prev = n;
            amplitude *= 0.55;
            frequency *= 2.03;
        }
        return total;
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private static double clamp(double v, double min, double max) {
        return v < min ? min : Math.min(v, max);
    }
}

