/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension.noise;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public class Crater
implements DensityFunction {
    public static final ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)"crater");
    private final double scale;
    public static final MapCodec<Crater> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("scale").forGetter(crater -> crater.scale)).apply((Applicative)instance, Crater::new));
    public static final KeyDispatchDataCodec<Crater> CODEC = KeyDispatchDataCodec.m_216238_(MAP_CODEC);

    public Crater(double scale) {
        this.scale = scale;
    }

    public double m_207386_(DensityFunction.FunctionContext context) {
        int x = context.m_207115_();
        int z = context.m_207113_();
        double frequency = 0.5;
        double scaledX = frequency * (double)x / this.scale;
        double scaledZ = frequency * (double)z / this.scale;
        double scaleY = this.scale / 1280.0;
        int cellX = (int)Math.floor(scaledX);
        int cellZ = (int)Math.floor(scaledZ);
        double minDist = Double.MAX_VALUE;
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                int neighborCellX = cellX + offsetX;
                int neighborCellZ = cellZ + offsetZ;
                long seed = this.hashCell(neighborCellX, neighborCellZ);
                double randomX = (double)neighborCellX + this.lcgRandom(seed);
                double randomZ = (double)neighborCellZ + this.lcgRandom(seed + 1L);
                double cellSizeVariation = 0.7 + this.lcgRandom(seed + 2L) * 0.6;
                double dx = (scaledX - randomX) / cellSizeVariation;
                double dz = (scaledZ - randomZ) / cellSizeVariation;
                double dist = dx * dx + dz * dz;
                minDist = Math.min(minDist, dist);
            }
        }
        double crater = 12.0 * minDist / (frequency * frequency);
        return scaleY * (crater - 0.5) / Math.max(1.0, crater * crater * crater);
    }

    private long hashCell(int x, int z) {
        long h = (long)x * 374761393L + (long)z * 668265263L;
        h = (h ^ h >> 13) * 1274126177L;
        return h ^ h >> 16;
    }

    private double lcgRandom(long seed) {
        seed = seed * 1103515245L + 12345L & Integer.MAX_VALUE;
        return (double)seed / 2.147483647E9;
    }

    public void m_207362_(double[] arr, @NotNull DensityFunction.ContextProvider provider) {
        for (int i = 0; i < arr.length; ++i) {
            DensityFunction.FunctionContext ctx = provider.m_207263_(i);
            arr[i] = this.m_207386_(ctx);
        }
    }

    @NotNull
    public DensityFunction m_207456_(@NotNull DensityFunction.Visitor visitor) {
        return this;
    }

    public double m_207402_() {
        return 0.0;
    }

    public double m_207401_() {
        return -1.0;
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }
}

