/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.dimension.noise;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import shipwrights.dataplanets.systemCreation.PlanetData;
import shipwrights.dataplanets.systemCreation.SystemCreator;
import shipwrights.dataplanets.util.RegistryUtil;

public class TerrainGenCreator {
    public static Holder.Reference<NoiseGeneratorSettings> createFromPlanetData(PlanetData planetData, SystemCreator.SystemCreationContext context) {
        int seaLevel = (int)(planetData.seaLevel() * 63.0);
        BlockState defaultBlock = TerrainGenCreator.getBlockState(planetData.primaryBlock());
        BlockState defaultFluid = TerrainGenCreator.getBlockState(planetData.primaryFluid());
        NoiseSettings noiseSettings = TerrainGenCreator.createNoiseSettings(planetData);
        NoiseRouter noiseRouter = TerrainGenCreator.createNoiseRouter(planetData, context);
        SurfaceRules.RuleSource surfaceRule = TerrainGenCreator.createSurfaceRules(planetData);
        List spawnTarget = new OverworldBiomeBuilder().m_187154_();
        boolean disableMobGeneration = false;
        boolean aquifersEnabled = planetData.seaLevel() > 0.3;
        boolean oreVeinsEnabled = true;
        boolean useLegacyRandomSource = false;
        NoiseGeneratorSettings noiseGeneratorSettings = new NoiseGeneratorSettings(noiseSettings, defaultBlock, defaultFluid, noiseRouter, surfaceRule, spawnTarget, seaLevel, disableMobGeneration, aquifersEnabled, oreVeinsEnabled, useLegacyRandomSource);
        ResourceLocation noiseSettingsLocation = ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)(planetData.name() + "_noise_settings"));
        ResourceKey noiseSettingsKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)noiseSettingsLocation);
        RegistryUtil.registerNoiseSettings(context.server, noiseSettingsLocation, noiseGeneratorSettings);
        return context.server.m_206579_().m_175515_(Registries.f_256932_).m_246971_(noiseSettingsKey);
    }

    private static NoiseSettings createNoiseSettings(PlanetData planetData) {
        int minY = -64;
        int height = 384;
        if (planetData.size() > 1.5) {
            height = 448;
        } else if (planetData.size() < 0.5) {
            height = 256;
            minY = -32;
        }
        int horizontalSize = planetData.terrainRoughness() > 1.5 ? 1 : 2;
        int verticalSize = 2;
        return NoiseSettings.m_224525_((int)minY, (int)height, (int)horizontalSize, (int)verticalSize);
    }

    private static double clampClimateParameter(double value) {
        return Math.max(-1.99, Math.min(1.99, value));
    }

    private static NoiseRouter createNoiseRouter(PlanetData planetData, SystemCreator.SystemCreationContext context) {
        HolderLookup.RegistryLookup noiseRegistry = context.server.m_206579_().m_255025_(Registries.f_256865_);
        HolderLookup.RegistryLookup densityFunctionRegistry = context.server.m_206579_().m_255025_(Registries.f_257040_);
        double noiseScale = Math.max(0.1, planetData.terrainRoughness());
        double noiseAmplitude = planetData.size() * 0.3;
        double weirdnessFactor = Math.abs(planetData.weirdness());
        double seaLevelOffset = (planetData.seaLevel() - 1.0) * 16.0;
        double temperature = TerrainGenCreator.clampClimateParameter(planetData.temperature());
        double vegetation = TerrainGenCreator.clampClimateParameter(planetData.atmosphericDensity());
        double erosion = TerrainGenCreator.clampClimateParameter(planetData.weirdness() * 0.8);
        double ridges = TerrainGenCreator.clampClimateParameter(planetData.terrainRoughness() * 0.8);
        Holder.Reference shiftNoise = noiseRegistry.m_255043_(Noises.f_189286_);
        Holder.Reference continentalnessNoise = noiseRegistry.m_255043_(Noises.f_189279_);
        DensityFunction shiftA = DensityFunctions.m_208366_((Holder)shiftNoise);
        DensityFunction shiftB = DensityFunctions.m_208378_((Holder)shiftNoise);
        DensityFunction baseTerrainNoise = weirdnessFactor > 1.5 ? DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)(noiseAmplitude * 0.9)), (DensityFunction)DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189246_), (double)(noiseScale * 1.2), (double)(noiseScale * 0.6))) : (planetData.terrainRoughness() > 1.3 ? DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)(noiseAmplitude * 0.75)), (DensityFunction)DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189255_), (double)noiseScale, (double)(noiseScale * 0.5))) : (planetData.terrainRoughness() < 0.7 ? DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)(noiseAmplitude * 0.4)), (DensityFunction)DensityFunctions.m_208368_((Holder)continentalnessNoise, (double)(noiseScale * 0.4), (double)(noiseScale * 0.2))) : DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)(noiseAmplitude * 0.6)), (DensityFunction)DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189285_), (double)(noiseScale * 0.8), (double)(noiseScale * 0.4)))));
        DensityFunction detailNoise = Math.abs(planetData.flavour()) > 0.5 ? DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)(noiseAmplitude * 0.15)), (DensityFunction)DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189267_), (double)(noiseScale * 2.0), (double)noiseScale)) : DensityFunctions.m_208263_();
        DensityFunction continents = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)(planetData.size() * 0.2)), (DensityFunction)DensityFunctions.m_208368_((Holder)continentalnessNoise, (double)0.08, (double)0.04));
        DensityFunction depth = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)(erosion * 0.25)), (DensityFunction)DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189280_), (double)0.15, (double)0.08));
        DensityFunction craters = planetData.atmosphericDensity() < 0.5 ? DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)((DensityFunction)densityFunctionRegistry.m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)"crater0"))).get()), (DensityFunction)((DensityFunction)densityFunctionRegistry.m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)"crater1"))).get())), (DensityFunction)((DensityFunction)densityFunctionRegistry.m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dataplanets", (String)"crater2"))).get())) : DensityFunctions.m_208263_();
        DensityFunction combinedTerrain = DensityFunctions.m_208293_((DensityFunction)baseTerrainNoise, (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)detailNoise, (DensityFunction)continents), (DensityFunction)craters));
        DensityFunction finalDensity = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-64, (int)320, (double)1.0, (double)-1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)combinedTerrain, (DensityFunction)DensityFunctions.m_208293_((DensityFunction)depth, (DensityFunction)DensityFunctions.m_208264_((double)(seaLevelOffset * 0.008)))));
        Holder.Reference temperatureNoise = noiseRegistry.m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256865_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"temperature")));
        Holder.Reference vegetationNoise = noiseRegistry.m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256865_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"vegetation")));
        Holder.Reference erosionNoise = noiseRegistry.m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256865_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"erosion")));
        Holder.Reference ridgeNoise = noiseRegistry.m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256865_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ridge")));
        DensityFunction aquiferFloodedness = planetData.seaLevel() > 0.5 ? DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189288_), (double)1.0, (double)0.0) : DensityFunctions.m_208263_();
        DensityFunction aquiferSpread = planetData.seaLevel() > 0.5 ? DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189290_), (double)1.0, (double)0.0) : DensityFunctions.m_208263_();
        DensityFunction lavaNoise = planetData.temperature() > 1.5 ? DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189289_), (double)1.0, (double)0.0) : DensityFunctions.m_208264_((double)-1.0);
        return new NoiseRouter(DensityFunctions.m_208263_(), aquiferFloodedness, aquiferSpread, lavaNoise, DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)temperature), (DensityFunction)DensityFunctions.m_208296_((DensityFunction)shiftA, (DensityFunction)shiftB, (double)0.25, (Holder)temperatureNoise)), DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)vegetation), (DensityFunction)DensityFunctions.m_208296_((DensityFunction)shiftA, (DensityFunction)shiftB, (double)0.25, (Holder)vegetationNoise)), continents, DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)erosion), (DensityFunction)DensityFunctions.m_208296_((DensityFunction)shiftA, (DensityFunction)shiftB, (double)0.25, (Holder)erosionNoise)), depth, DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)ridges), (DensityFunction)DensityFunctions.m_208296_((DensityFunction)shiftA, (DensityFunction)shiftB, (double)0.25, (Holder)ridgeNoise)), baseTerrainNoise, finalDensity, DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189247_), (double)1.0, (double)1.0), DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189248_), (double)1.0, (double)1.0), DensityFunctions.m_208368_((Holder)noiseRegistry.m_255043_(Noises.f_189250_), (double)1.0, (double)1.0));
    }

    private static SurfaceRules.RuleSource createSurfaceRules(PlanetData planetData) {
        BlockState primaryBlock = TerrainGenCreator.getBlockState(planetData.primaryBlock());
        SurfaceRules.RuleSource primarySurface = SurfaceRules.m_189390_((BlockState)primaryBlock);
        if (planetData.temperature() > 1.5) {
            return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)Blocks.f_49993_.m_49966_())), primarySurface});
        }
        if (planetData.temperature() < 0.5) {
            return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)Blocks.f_50127_.m_49966_())), primarySurface});
        }
        if (planetData.weirdness() > 1.5) {
            return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)Blocks.f_152544_.m_49966_())), primarySurface});
        }
        return primarySurface;
    }

    private static BlockState getBlockState(ResourceLocation resourceLocation) {
        return ((Block)BuiltInRegistries.f_256975_.m_7745_(resourceLocation)).m_49966_();
    }
}

