/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.systemCreation.naming;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import shipwrights.dataplanets.systemCreation.naming.SystemNameGenerator;

public class FantasySystemNameGenerator
extends SimpleJsonResourceReloadListener
implements SystemNameGenerator {
    private static final Gson GSON = new GsonBuilder().create();
    private final List<String> names = new ArrayList<String>();
    private static final List<String> DEFAULT_NAMES = List.of("Aetheria", "Celestia", "Draconis", "Elysium", "Hyperion", "Mystara", "Nexus", "Olympus", "Pandora", "Solaris", "Tartarus", "Umbra", "Valhalla", "Xanadu", "Zephyr");

    public FantasySystemNameGenerator() {
        super(GSON, "system_names");
        this.names.addAll(DEFAULT_NAMES);
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.names.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : data.entrySet()) {
            try {
                JsonElement json = entry.getValue();
                if (!json.isJsonObject() || !json.getAsJsonObject().has("names")) continue;
                JsonArray namesArray = json.getAsJsonObject().getAsJsonArray("names");
                for (JsonElement nameElement : namesArray) {
                    if (!nameElement.isJsonPrimitive() || !nameElement.getAsJsonPrimitive().isString()) continue;
                    this.names.add(nameElement.getAsString());
                }
            }
            catch (JsonParseException e) {
                System.err.println("Failed to parse system names from " + entry.getKey() + ": " + e.getMessage());
            }
        }
        if (this.names.isEmpty()) {
            this.names.addAll(DEFAULT_NAMES);
        }
    }

    @Override
    public String generate(RandomSource random) {
        if (this.names.isEmpty()) {
            return "Unknown";
        }
        return this.names.get(random.m_188503_(this.names.size())).toLowerCase(Locale.ROOT) + "-" + random.m_188503_(10);
    }

    public List<String> getAvailableNames() {
        return new ArrayList<String>(this.names);
    }
}

