/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.util;

public record Color(int red, int green, int blue, int alpha) {
    public Color {
        red = Color.clamp(red);
        green = Color.clamp(green);
        blue = Color.clamp(blue);
        alpha = Color.clamp(alpha);
    }

    public Color(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    private static int clamp(int value) {
        return Math.max(0, Math.min(255, value));
    }

    public static Color fromInt(int rgba) {
        int red = rgba >> 24 & 0xFF;
        int green = rgba >> 16 & 0xFF;
        int blue = rgba >> 8 & 0xFF;
        int alpha = rgba & 0xFF;
        return new Color(red, green, blue, alpha);
    }

    public int toInt() {
        return this.red << 24 | this.green << 16 | this.blue << 8 | this.alpha;
    }

    public Color withAlpha(int alpha) {
        return new Color(this.red, this.green, this.blue, alpha);
    }

    public Color withRed(int red) {
        return new Color(red, this.green, this.blue, this.alpha);
    }

    public Color withGreen(int green) {
        return new Color(this.red, green, this.blue, this.alpha);
    }

    public Color withBlue(int blue) {
        return new Color(this.red, this.green, blue, this.alpha);
    }

    public String toHexString() {
        return String.format("#%02X%02X%02X%02X", this.red, this.green, this.blue, this.alpha);
    }

    public String toHexStringNoAlpha() {
        return String.format("#%02X%02X%02X", this.red, this.green, this.blue);
    }

    @Override
    public String toString() {
        return String.format("Color(r=%d, g=%d, b=%d, a=%d)", this.red, this.green, this.blue, this.alpha);
    }
}

