/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.dataplanets.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.storage.LevelResource;
import shipwrights.dataplanets.DataplanetsMod;

public class RegistryUtil {
    public static void registerBiome(MinecraftServer server, ResourceLocation resourceLocation, Biome biome) {
        RegistryUtil.registerThing(server, Registries.f_256952_, ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)resourceLocation), biome);
        RegistryUtil.writeToDatapack(server, resourceLocation, "worldgen/biome", Biome.f_47429_, biome);
    }

    public static void addBiomeToTag(MinecraftServer server, ResourceLocation biomeLocation, TagKey<Biome> tag) {
        RegistryUtil.addBiomeToTag(server, tag, biomeLocation);
    }

    public static void registerDimensionType(MinecraftServer server, ResourceLocation resourceLocation, DimensionType dimensionType) {
        RegistryUtil.registerThing(server, Registries.f_256787_, ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)resourceLocation), dimensionType);
        RegistryUtil.writeToDatapack(server, resourceLocation, "dimension_type", DimensionType.f_63843_, dimensionType);
    }

    public static void registerLevelStem(MinecraftServer server, ResourceLocation resourceLocation, LevelStem levelStem) {
        RegistryUtil.registerThing(server, Registries.f_256862_, ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)resourceLocation), levelStem);
        RegistryUtil.writeToDatapack(server, resourceLocation, "dimension", LevelStem.f_63970_, levelStem);
    }

    public static void registerConfiguredCarver(MinecraftServer server, ResourceLocation resourceLocation, ConfiguredWorldCarver<?> configuredCarver) {
        RegistryUtil.registerThing(server, Registries.f_257003_, ResourceKey.m_135785_((ResourceKey)Registries.f_257003_, (ResourceLocation)resourceLocation), configuredCarver);
    }

    public static void registerPlacedFeature(MinecraftServer server, ResourceLocation resourceLocation, PlacedFeature placedFeature) {
        RegistryUtil.registerThing(server, Registries.f_256988_, ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)resourceLocation), placedFeature);
        RegistryUtil.writeToDatapack(server, resourceLocation, "worldgen/placed_feature", PlacedFeature.f_191772_, placedFeature);
    }

    public static void registerConfiguredFeature(MinecraftServer server, ResourceLocation resourceLocation, ConfiguredFeature<?, ?> configuredFeature) {
        RegistryUtil.registerThing(server, Registries.f_256911_, ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)resourceLocation), configuredFeature);
        RegistryUtil.writeToDatapack(server, resourceLocation, "worldgen/configured_feature", ConfiguredFeature.f_65373_, configuredFeature);
    }

    public static void registerNoise(MinecraftServer server, ResourceLocation resourceLocation, NormalNoise.NoiseParameters noiseParameters) {
        RegistryUtil.registerThing(server, Registries.f_256865_, ResourceKey.m_135785_((ResourceKey)Registries.f_256865_, (ResourceLocation)resourceLocation), noiseParameters);
    }

    public static void registerNoiseSettings(MinecraftServer server, ResourceLocation resourceLocation, NoiseGeneratorSettings noiseGeneratorSettings) {
        RegistryUtil.registerThing(server, Registries.f_256932_, ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)resourceLocation), noiseGeneratorSettings);
        RegistryUtil.writeToDatapack(server, resourceLocation, "worldgen/noise_settings", NoiseGeneratorSettings.f_64430_, noiseGeneratorSettings);
    }

    private static <T> void registerThing(MinecraftServer server, ResourceKey<Registry<T>> registry, ResourceKey<T> keyToRegister, T thingToRegister) {
        Registry reg = server.m_206579_().m_175515_(registry);
        if (!(reg instanceof MappedRegistry)) {
            throw new IllegalArgumentException("Cannot modify registry: " + registry.m_211136_());
        }
        MappedRegistry mapped = (MappedRegistry)reg;
        mapped.unfreeze();
        mapped.m_255290_(keyToRegister, thingToRegister, Lifecycle.experimental());
        mapped.m_203521_();
    }

    public static boolean setupDatapackFolder(MinecraftServer server) {
        Path basePath = server.f_129744_.m_78283_(LevelResource.f_78180_);
        Path dataplanetsFolder = basePath.resolve("dataplanets-generated");
        String mcMeta = "{\n  \"pack\": {\n    \"description\": \"Dataplanets Generated\",\n    \"forge:server_data_pack_format\": 15,\n    \"pack_format\": 15\n  }\n}";
        boolean newFolderCreated = false;
        try {
            Path mcMetaPath;
            if (!Files.exists(dataplanetsFolder, new LinkOption[0])) {
                Files.createDirectories(dataplanetsFolder, new FileAttribute[0]);
                newFolderCreated = true;
            }
            if (!Files.exists(mcMetaPath = dataplanetsFolder.resolve("pack.mcmeta"), new LinkOption[0])) {
                Files.writeString(mcMetaPath, (CharSequence)mcMeta, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create dataplanets-generated folder", e);
        }
        return newFolderCreated;
    }

    public static <T> void writeToDatapack(MinecraftServer server, ResourceLocation resourceLocation, String path, Codec<T> codec, T object) {
        Path basePath = server.f_129744_.m_78283_(LevelResource.f_78180_);
        Path dataplanetsFolder = basePath.resolve("dataplanets-generated");
        Path typeFolder = dataplanetsFolder.resolve("data").resolve(resourceLocation.m_135827_()).resolve(path);
        Path objectFile = typeFolder.resolve(resourceLocation.m_135815_() + ".json");
        try {
            Files.createDirectories(typeFolder, new FileAttribute[0]);
            RegistryAccess.Frozen registryAccess = server.m_206579_();
            RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
            DataResult result = codec.encodeStart((DynamicOps)registryOps, object);
            if (result.error().isPresent()) {
                DataplanetsMod.LOGGER.error("Warning: Failed to encode " + path + " for " + resourceLocation + ": " + ((DataResult.PartialResult)result.error().get()).message());
                DataplanetsMod.LOGGER.error("Skipping datapack file generation for this object.");
                return;
            }
            JsonElement json = (JsonElement)result.result().orElseThrow();
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson(json);
            Files.writeString(objectFile, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write " + path + " file: " + resourceLocation, e);
        }
    }

    private static void addBiomeToTag(MinecraftServer server, TagKey<Biome> tag, ResourceLocation biomeLocation) {
        RegistryUtil.bindBiomeToTagRuntime(server, tag, biomeLocation);
        Path basePath = server.f_129744_.m_78283_(LevelResource.f_78180_);
        Path dataplanetsFolder = basePath.resolve("dataplanets-generated");
        Path tagFolder = dataplanetsFolder.resolve("data").resolve(tag.f_203868_().m_135827_()).resolve("tags").resolve("worldgen").resolve("biome");
        Path tagFile = tagFolder.resolve(tag.f_203868_().m_135815_() + ".json");
        try {
            String biomeId;
            String content;
            JsonObject json;
            Files.createDirectories(tagFile.getParent(), new FileAttribute[0]);
            ArrayList<String> values = new ArrayList<String>();
            if (Files.exists(tagFile, new LinkOption[0]) && (json = JsonParser.parseString((String)(content = Files.readString(tagFile))).getAsJsonObject()).has("values")) {
                json.getAsJsonArray("values").forEach(element -> values.add(element.getAsString()));
            }
            if (!values.contains(biomeId = biomeLocation.toString())) {
                values.add(biomeId);
            }
            JsonObject tagJson = new JsonObject();
            tagJson.addProperty("replace", Boolean.valueOf(false));
            JsonArray valuesArray = new JsonArray();
            values.forEach(arg_0 -> ((JsonArray)valuesArray).add(arg_0));
            tagJson.add("values", (JsonElement)valuesArray);
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)tagJson);
            Files.writeString(tagFile, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to add biome to tag: " + tag.f_203868_(), e);
        }
    }

    private static void bindBiomeToTagRuntime(MinecraftServer server, TagKey<Biome> tag, ResourceLocation biomeLocation) {
        try {
            Registry biomeRegistry = server.m_206579_().m_175515_(Registries.f_256952_);
            ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeLocation);
            Holder.Reference biomeHolder = biomeRegistry.m_246971_(biomeKey);
            ArrayList<Holder.Reference> holders = new ArrayList<Holder.Reference>();
            Optional existingTag = biomeRegistry.m_203431_(tag);
            existingTag.ifPresent(namedSet -> namedSet.forEach(holders::add));
            if (!holders.contains(biomeHolder)) {
                holders.add(biomeHolder);
            }
            if (biomeRegistry instanceof MappedRegistry) {
                MappedRegistry mapped = (MappedRegistry)biomeRegistry;
                mapped.unfreeze();
                HashMap<TagKey<Biome>, ArrayList<Holder.Reference>> tagMap = new HashMap<TagKey<Biome>, ArrayList<Holder.Reference>>();
                mapped.m_203612_().forEach(pair -> {
                    TagKey existingTagKey = (TagKey)pair.getFirst();
                    ArrayList existingHolders = new ArrayList();
                    ((HolderSet.Named)pair.getSecond()).forEach(existingHolders::add);
                    tagMap.put(existingTagKey, existingHolders);
                });
                tagMap.put(tag, holders);
                mapped.m_203652_(tagMap);
                mapped.m_203521_();
            }
        }
        catch (Exception e) {
            DataplanetsMod.LOGGER.error("Warning: Could not bind biome to tag at runtime: " + e.getMessage());
            DataplanetsMod.LOGGER.error("Tag will take effect after datapack reload.");
        }
    }
}

