/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.event.AtmosphericCollision;
import shipwrights.genesis.event.PlanetCollision;

@Mod.EventBusSubscriber
public class GenesisEvents {
    public static Component message = Component.m_237119_();
    private static int wormholeLightningTimer = 0;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        switch (event.phase) {
            case START: {
                break;
            }
            case END: {
                if (serverLevel.m_261156_(player -> true, 1).isEmpty()) {
                    return;
                }
                AtmosphericCollision.atmosphericCollisionTick(serverLevel);
                PlanetCollision.planetCollisionTick(serverLevel);
                if (!serverLevel.m_46472_().m_135782_().equals((Object)GenesisMod.WORMHOLE_DIM)) break;
                GenesisEvents.wormholeLightningTick(serverLevel);
            }
        }
    }

    private static void wormholeLightningTick(ServerLevel wormholeLevel) {
        if (++wormholeLightningTimer >= 20) {
            List players;
            wormholeLightningTimer = 0;
            if (wormholeLevel.f_46441_.m_188501_() < 0.05f && !(players = wormholeLevel.m_8795_(player -> true)).isEmpty()) {
                ServerPlayer randomPlayer = (ServerPlayer)players.get(wormholeLevel.f_46441_.m_188503_(players.size()));
                double distance = 30.0 + wormholeLevel.f_46441_.m_188500_() * 50.0;
                double angle = wormholeLevel.f_46441_.m_188500_() * Math.PI * 2.0;
                Vec3 playerPos = randomPlayer.m_20182_();
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                BlockPos lightningPos = new BlockPos((int)(playerPos.f_82479_ + offsetX), (int)playerPos.f_82480_ + wormholeLevel.f_46441_.m_216339_(-25, 25), (int)(playerPos.f_82481_ + offsetZ));
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)wormholeLevel);
                if (lightning != null) {
                    lightning.m_20219_(Vec3.m_82539_((Vec3i)lightningPos));
                    lightning.m_20874_(true);
                    wormholeLevel.m_7967_((Entity)lightning);
                }
            }
        }
    }
}

